/*
 * Decompiled with CFR 0.152.
 */
package similarity;

import com.aliasi.matrix.SparseFloatVector;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import segmenter.IDataSource;
import segmenter.TextFileIO;
import similarity.CosineVectorSimilarity;
import similarity.ISimComputer;
import similarity.ISimMetric;
import similarity.SentTokenVector;
import similarity.TokenDictionary;
import similarity.TooManyPointsException;
import similarity.TripletSim;

public class CosineSimComputer
implements ISimComputer {
    IDataSource dataSource = null;
    ISimMetric simMetric = null;
    int MAX_NUM_POINTS = 1000;
    TripletSim minSim = new TripletSim(0, 0, 1.0);
    TripletSim maxSim = null;
    double netSim = 0.0;
    double meanSim = 0.0;
    int positiveSimCounter = 0;
    boolean useSparseMatrix = false;
    int windowSize = -1;
    LinkedList<TripletSim> similarities = null;
    File outputDir = null;
    TokenDictionary tokenDict;
    ArrayList<SentTokenVector> sentVectors = null;
    String fieldDelimiter = "\t";
    String lineDelimiter = "\n";
    static Pattern namePattern = Pattern.compile("[^\\.]+");

    @Override
    public void Init(IDataSource iDataSource) {
        this.dataSource = iDataSource;
        this.simMetric = new CosineVectorSimilarity();
    }

    public void SetUp(TokenDictionary tokenDictionary, int n, boolean bl, File file) {
        this.tokenDict = tokenDictionary;
        this.windowSize = n;
        this.useSparseMatrix = bl;
        this.outputDir = file;
        this.similarities = new LinkedList();
    }

    @Override
    public void ComputeSimilarities() throws TooManyPointsException {
        if (!this.useSparseMatrix) {
            this.ComputeDenseSimMatrix();
        } else {
            this.ComputeSparseSimMatrix();
        }
    }

    public void ComputeSentenceVectors() {
        int n = this.dataSource.GetNumChunks();
        ArrayList<SentTokenVector> arrayList = new ArrayList<SentTokenVector>();
        for (int i = 0; i < n; ++i) {
            String string = this.dataSource.GetChunk(i);
            SentTokenVector sentTokenVector = new SentTokenVector(string, this.tokenDict, i, false);
            arrayList.add(sentTokenVector);
        }
        this.sentVectors = arrayList;
        System.out.println("created token-frequency vectors");
    }

    public void SetSentenceVectors(ArrayList<SentTokenVector> arrayList) {
        this.sentVectors = arrayList;
    }

    public void ForgetSentVectors() {
        this.sentVectors = null;
    }

    private void ComputeDenseSimMatrix() throws TooManyPointsException {
        CosineVectorSimilarity cosineVectorSimilarity = (CosineVectorSimilarity)this.simMetric;
        try {
            int n = this.dataSource.GetNumChunks();
            if (n > this.MAX_NUM_POINTS) {
                TooManyPointsException tooManyPointsException = new TooManyPointsException("Exception: running ComputeComputeDenseSimMatrix with " + String.valueOf(n) + " point. Max number is " + String.valueOf(this.MAX_NUM_POINTS) + ". Use ComputeSparseSimMatrix");
                throw tooManyPointsException;
            }
            for (int i = 0; i < this.sentVectors.size(); ++i) {
                SparseFloatVector sparseFloatVector = this.sentVectors.get(i).getFreqVector();
                for (int j = 0; j < this.sentVectors.size(); ++j) {
                    SparseFloatVector sparseFloatVector2 = this.sentVectors.get(j).getFreqVector();
                    double d = cosineVectorSimilarity.MeasureSimilarity(sparseFloatVector, sparseFloatVector2);
                    TripletSim tripletSim = new TripletSim(i, j, d);
                    this.similarities.add(tripletSim);
                    this.ComputeMinMaxNetSimilarity(tripletSim);
                }
            }
            this.ComputeMeanSim();
        }
        catch (Exception exception) {
            System.out.println("Exception in ComputeDenseSimMatrix");
            System.out.println(exception.getMessage() + "\n" + exception.getStackTrace());
        }
    }

    private void ComputeMinMaxNetSimilarity(TripletSim tripletSim) {
        if (this.minSim == null) {
            this.minSim = tripletSim;
        } else if (tripletSim.similarity > 0.0 && tripletSim.similarity < this.minSim.similarity) {
            this.minSim = tripletSim;
        }
        if (this.maxSim == null) {
            this.maxSim = tripletSim;
        } else if (this.maxSim.similarity < tripletSim.similarity) {
            this.maxSim = tripletSim;
        }
        this.netSim += tripletSim.similarity;
        if (tripletSim.similarity > 0.0) {
            ++this.positiveSimCounter;
        }
    }

    private void ComputeSparseSimMatrix() {
        try {
            CosineVectorSimilarity cosineVectorSimilarity = (CosineVectorSimilarity)this.simMetric;
            for (int i = 0; i < this.sentVectors.size(); ++i) {
                SparseFloatVector sparseFloatVector = this.sentVectors.get(i).getFreqVector();
                int n = (int)Math.ceil(this.windowSize / 2);
                int n2 = i - n;
                int n3 = n2 + this.windowSize - 1;
                for (int j = 0; j < this.sentVectors.size(); ++j) {
                    SparseFloatVector sparseFloatVector2 = this.sentVectors.get(j).getFreqVector();
                    TripletSim tripletSim = null;
                    if (j < n2 || j > n3) continue;
                    double d = cosineVectorSimilarity.MeasureSimilarity(sparseFloatVector, sparseFloatVector2);
                    tripletSim = new TripletSim(i, j, d);
                    this.similarities.add(tripletSim);
                    this.ComputeMinMaxNetSimilarityForSparse(tripletSim);
                }
            }
            this.ComputeMeanSim();
        }
        catch (Exception exception) {
            System.out.println("Exception in AffinityPropagationSegmentor.ComputeSparseMatrix");
            System.out.println(exception.getMessage());
        }
    }

    private void ComputeMinMaxNetSimilarityForSparse(TripletSim tripletSim) {
        if (this.minSim == null) {
            this.minSim = tripletSim;
        } else if (tripletSim.similarity > 0.0 && tripletSim.similarity < this.minSim.similarity) {
            this.minSim = tripletSim;
        }
        if (this.maxSim == null) {
            this.maxSim = tripletSim;
        } else if (this.maxSim.similarity < tripletSim.similarity) {
            this.maxSim = tripletSim;
        }
        this.netSim += tripletSim.similarity;
        if (tripletSim.similarity > 0.0) {
            ++this.positiveSimCounter;
        }
    }

    private void ComputeMeanSim() {
        this.meanSim = this.netSim / (double)this.positiveSimCounter;
    }

    @Override
    public void OutputSimilarities(File file) {
        this.GenerateMatLabFiles();
    }

    public void GenerateMatLabFiles() {
        Object object2;
        String string = this.dataSource.GetName();
        Matcher matcher = namePattern.matcher(string);
        if (matcher.find()) {
            string = matcher.group(0);
        }
        File file = new File(this.outputDir, string + "_sent_text.txt");
        File file2 = new File(this.outputDir, string + "_sent_sim.txt");
        File file3 = new File(this.outputDir, string + "_sent_pref_min.txt");
        File file4 = new File(this.outputDir, string + "_sent_pref_mean.txt");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.dataSource.GetNumChunks(); ++i) {
            object2 = String.valueOf(i) + "\t" + this.dataSource.GetChunk(i) + "\n";
            stringBuilder.append((String)object2);
        }
        TextFileIO.OutputFile(file, stringBuilder.toString());
        StringBuilder stringBuilder2 = new StringBuilder();
        for (TripletSim object3 : this.similarities) {
            String i = String.valueOf(object3.firstId) + this.fieldDelimiter + String.valueOf(object3.secondId) + this.fieldDelimiter + String.valueOf(object3.similarity) + this.lineDelimiter;
            stringBuilder2.append(i);
        }
        TextFileIO.OutputFile(file2, stringBuilder2.toString());
        object2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        for (int i = 0; i < this.dataSource.GetNumChunks(); ++i) {
            ((StringBuilder)object2).append(String.valueOf(this.meanSim) + this.lineDelimiter);
            stringBuilder3.append(String.valueOf(this.minSim.similarity) + this.lineDelimiter);
        }
        TextFileIO.OutputFile(file3, stringBuilder3.toString());
        TextFileIO.OutputFile(file4, ((StringBuilder)object2).toString());
    }

    @Override
    public LinkedList<TripletSim> GetSimilarities() {
        return this.similarities;
    }

    @Override
    public IDataSource GetRawData() {
        return this.dataSource;
    }

    @Override
    public int GetPointsNumber() {
        return this.dataSource.GetNumChunks();
    }

    @Override
    public boolean GetIfSparse() {
        return this.useSparseMatrix;
    }

    @Override
    public int GetWindowSize() {
        if (!this.useSparseMatrix) {
            return this.GetPointsNumber();
        }
        return this.windowSize;
    }
}

