/*
 * Decompiled with CFR 0.152.
 */
package segmenter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import segmenter.IDataSource;
import segmenter.TextFileIO;

public class SimpleFileDataSource
implements IDataSource {
    private ArrayList<String> chunks = new ArrayList();
    private ArrayList<Integer> refBreaks = new ArrayList();
    private Pattern segmPattern;
    private String segmString = "==========";
    private File inputFile;

    public SimpleFileDataSource(File file, String string) {
        this.segmPattern = Pattern.compile(string);
        this.inputFile = file;
    }

    @Override
    public void Init(int n) throws Exception {
        if (n == 1) {
            this.InitSentLevel();
        } else if (n == 2) {
            this.InitParLevel();
        } else {
            Exception exception = new Exception("Exception in SimpleFileDataSource.Init(): Invalid value of basic units " + String.valueOf(n));
            throw exception;
        }
    }

    private void InitSentLevel() {
        try {
            Object object;
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.inputFile));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.isEmpty()) continue;
                object = this.segmPattern.matcher(string);
                if (((Matcher)object).matches()) {
                    if (this.chunks.size() <= 0) continue;
                    this.refBreaks.add(this.chunks.size() - 1);
                    continue;
                }
                this.chunks.add(string);
            }
            object = this.refBreaks.get(this.refBreaks.size() - 1);
            if ((Integer)object < this.GetNumChunks() - 1) {
                this.refBreaks.add(new Integer(this.GetNumChunks() - 1));
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in SimpleFileDataSource.InitSentLevel(): " + exception.getMessage());
        }
    }

    private void InitParLevel() {
        boolean bl = false;
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.inputFile));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                if (string.isEmpty()) {
                    if (bl) continue;
                    bl = true;
                    this.chunks.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    continue;
                }
                bl = false;
                Matcher matcher = this.segmPattern.matcher(string);
                if (matcher.matches()) {
                    this.refBreaks.add(this.chunks.size() - 1);
                    continue;
                }
                stringBuilder.append(" " + string);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in SimpleFileDataSource.InitParLevel(): " + exception.getMessage());
        }
    }

    @Override
    public String GetChunk(int n) {
        return this.chunks.get(n);
    }

    @Override
    public int GetNumChunks() {
        return this.chunks.size();
    }

    @Override
    public Integer[] GetReferenceSegmentBreaks() {
        return this.refBreaks.toArray(new Integer[this.refBreaks.size()]);
    }

    @Override
    public String GetName() {
        return this.inputFile.getName();
    }

    public void PrintChunks() {
        for (int i = 0; i < this.chunks.size(); ++i) {
            System.out.println("<" + String.valueOf(i) + ">\t" + this.chunks.get(i));
        }
    }

    @Override
    public void Output(File file, Integer[] integerArray) {
        if (integerArray == null || integerArray.length == 0) {
            integerArray = new Integer[]{new Integer(this.GetNumChunks() - 1)};
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = integerArray[n];
        for (int i = 0; i < this.GetNumChunks() - 1; ++i) {
            if (i <= n2) {
                stringBuilder.append(this.GetChunk(i) + "\n");
                continue;
            }
            stringBuilder.append(this.segmString + "\n");
            n2 = n < integerArray.length - 1 ? integerArray[++n] : Integer.MAX_VALUE;
        }
        stringBuilder.append(this.segmString + "\n");
        TextFileIO.OutputFile(file, stringBuilder.toString());
        System.out.println("output " + file.getAbsolutePath());
    }
}

