/*
 * Decompiled with CFR 0.152.
 */
package segmenter;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.TreeSet;
import segmenter.IMatrix;
import segmenter.ISegmenter;
import similarity.ISimComputer;

public abstract class AbstractAPSegmenterDP
implements ISegmenter {
    protected int numPoints;
    protected double dampFactor = 0.9;
    protected int maxIterations = 500;
    protected int maxConvCount = 300;
    protected IMatrix similarities;
    protected IMatrix resp;
    protected IMatrix avail;
    protected ArrayList<Integer> examplars = null;
    protected int convergenceCount = 0;
    protected TreeMap<Integer, TreeSet<Integer>> assignments = null;
    protected double maxSim = 0.0;
    protected double minSim = 0.0;
    private int numberOfThreads = Runtime.getRuntime().availableProcessors();
    private Thread[] threads = new WorkerThread[this.numberOfThreads];

    @Override
    public abstract void Init(ISimComputer var1) throws Exception;

    public int GetExamplarsCount() {
        return this.examplars.size();
    }

    void LoadSimilarities(String string) throws Exception {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split("\\s+");
            if (stringArray.length != 3) {
                throw new Exception("bad line in " + string + "\n" + string2);
            }
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            double d = Double.parseDouble(stringArray[2]);
            if (d < this.minSim) {
                this.minSim = d;
            }
            if (d > this.maxSim) {
                this.maxSim = d;
            }
            this.similarities.SetElement(n, n2, d);
        }
    }

    void LoadPreferences(String string) throws Exception {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            double d = Double.parseDouble(string2);
            this.similarities.SetElement(n, n, d);
            ++n;
        }
    }

    void SetPreferences(double d) throws Exception {
        for (int i = 0; i < this.similarities.GetNumRows(); ++i) {
            this.similarities.SetElement(i, i, d);
        }
    }

    protected boolean Iterate() throws Exception {
        int n;
        int n2;
        int n3;
        int n4 = this.similarities.GetNumRows() / this.numberOfThreads;
        int n5 = this.similarities.GetNumRows() % this.numberOfThreads;
        for (n3 = 0; n3 < this.numberOfThreads; ++n3) {
            n2 = n3 * n4;
            n = n2 + n4 - 1;
            if (n3 == this.numberOfThreads - 1) {
                n += n5;
            }
            this.threads[n3] = new WorkerThread(this, true, n2, n);
            this.threads[n3].start();
        }
        for (n3 = 0; n3 < this.numberOfThreads; ++n3) {
            this.threads[n3].join();
        }
        for (n3 = 0; n3 < this.numberOfThreads; ++n3) {
            n2 = n3 * n4;
            n = n2 + n4 - 1;
            if (n3 == this.numberOfThreads - 1) {
                n += n5;
            }
            this.threads[n3] = new WorkerThread(this, false, n2, n);
            this.threads[n3].start();
        }
        for (n3 = 0; n3 < this.numberOfThreads; ++n3) {
            this.threads[n3].join();
        }
        ArrayList<Integer> arrayList = this.GetExamplars();
        if (this.examplars == null || this.examplars.size() != arrayList.size() || this.examplars.size() == 0 || !this.examplars.containsAll(arrayList)) {
            this.examplars = arrayList;
            this.SetCurrentConvergenceCount(0);
        } else {
            this.IncrementConvergenceCount();
        }
        return this.convergenceCount > this.getMaxConvCount();
    }

    double DampenMessage(double d, double d2) {
        double d3 = this.dampFactor * d + (1.0 - this.dampFactor) * d2;
        return d3;
    }

    protected void CalcResponsibility(int n, int n2, int[] nArray) throws Exception {
        double d = Double.NEGATIVE_INFINITY;
        int n3 = this.similarities.GetRowStart(n);
        int n4 = this.similarities.GetRowEnd(n);
        if (nArray[0] == -1) {
            double d2 = Double.NEGATIVE_INFINITY;
            double d3 = Double.NEGATIVE_INFINITY;
            for (int i = n3; i <= n4; ++i) {
                double d4 = this.avail.GetElement(n, i) + this.similarities.GetElement(n, i);
                if (d4 > d2) {
                    d3 = d2;
                    d2 = d4;
                    nArray[1] = nArray[0];
                    nArray[0] = i;
                    continue;
                }
                if (!(d4 > d3)) continue;
                d3 = d4;
                nArray[1] = i;
            }
        }
        int n5 = -1;
        n5 = nArray[0] == n2 ? nArray[1] : nArray[0];
        d = this.avail.GetElement(n, n5) + this.similarities.GetElement(n, n5);
        double d5 = this.similarities.GetElement(n, n2) - d;
        this.resp.SetElement(n, n2, this.DampenMessage(this.resp.GetElement(n, n2), d5));
    }

    protected void CalcAvailability(int n, int n2) throws Exception {
        if (n == n2) {
            this.CalcA1(n);
        } else if (n < n2) {
            this.CalcA2(n, n2);
        } else {
            this.CalcA3(n, n2);
        }
    }

    void CalcA1(int n) throws Exception {
        int n2 = this.similarities.GetColumnStart(n);
        int n3 = this.similarities.GetColumnEnd(n);
        double d = this.MaximizeSumRL(n, n2, n - 1);
        double d2 = this.MaximizeSumLR(n, n + 1, n3);
        double d3 = Math.max(d, 0.0) + Math.max(d2, 0.0);
        this.avail.SetElement(n, n, this.DampenMessage(this.avail.GetElement(n, n), d3));
    }

    void CalcA2(int n, int n2) throws Exception {
        int n3 = this.similarities.GetColumnStart(n2);
        int n4 = this.similarities.GetColumnEnd(n2);
        double d = Math.max(0.0, this.MaximizeSumRL(n2, n3, n - 1));
        double d2 = this.Sum(n2, n + 1, n2);
        double d3 = Math.max(0.0, this.MaximizeSumLR(n2, n2 + 1, n4));
        double d4 = d + d2 + d3;
        double d5 = d;
        double d6 = this.MinimizeSumRL(n2, n + 1, n2 - 1);
        double d7 = this.Sum(n2, n + 1, n2 - 1);
        double d8 = Math.min(d6, d7);
        double d9 = d5 + d8;
        double d10 = Math.min(d4, d9);
        this.avail.SetElement(n, n2, this.DampenMessage(this.avail.GetElement(n, n2), d10));
    }

    void CalcA3(int n, int n2) throws Exception {
        int n3 = this.similarities.GetColumnStart(n2);
        int n4 = this.similarities.GetColumnEnd(n2);
        double d = Math.max(this.MaximizeSumRL(n2, n3, n2 - 1), 0.0);
        double d2 = this.Sum(n2, n2, n - 1);
        double d3 = Math.max(0.0, this.MaximizeSumLR(n2, n + 1, n4));
        double d4 = d + d2 + d3;
        double d5 = d3;
        double d6 = this.MinimizeSumLR(n2, n2 + 1, n - 1);
        double d7 = this.Sum(n2, n2 + 1, n - 1);
        double d8 = Math.min(d6, d7);
        double d9 = d5 + d8;
        double d10 = Math.min(d4, d9);
        this.avail.SetElement(n, n2, this.DampenMessage(this.avail.GetElement(n, n2), d10));
    }

    double MaximizeSumRL(int n, int n2, int n3) throws Exception {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = n3; i >= n2 && i >= 0; --i) {
            d2 += this.resp.GetElement(i, n);
            if (i == n3) {
                d = d2;
                continue;
            }
            if (!(d2 >= d)) continue;
            d = d2;
        }
        return d;
    }

    double MaximizeSumLR(int n, int n2, int n3) throws Exception {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = n2; i <= n3 && i < this.numPoints; ++i) {
            d2 += this.resp.GetElement(i, n);
            if (i == n2) {
                d = d2;
                continue;
            }
            if (!(d2 >= d)) continue;
            d = d2;
        }
        return d;
    }

    double MinimizeSumLR(int n, int n2, int n3) throws Exception {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = n2; i < this.numPoints && i <= n3; ++i) {
            d += this.resp.GetElement(i, n);
            if (i == n2) {
                d2 = d;
                continue;
            }
            if (!(d <= d2)) continue;
            d2 = d;
        }
        return d2;
    }

    double MinimizeSumRL(int n, int n2, int n3) throws Exception {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = n3; i >= 0 && i >= n2; --i) {
            d += this.resp.GetElement(i, n);
            if (i == n3) {
                d2 = d;
                continue;
            }
            if (!(d <= d2)) continue;
            d2 = d;
        }
        return d2;
    }

    double Sum(int n, int n2, int n3) throws Exception {
        if (n2 < 0 || n2 >= this.numPoints) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = n2; i <= n3 && i < this.numPoints; ++i) {
            d += this.resp.GetElement(i, n);
        }
        return d;
    }

    @Override
    public void Run() throws Exception {
        for (int i = 1; !this.Iterate() && i <= this.maxIterations; ++i) {
        }
    }

    ArrayList<Integer> GetExamplars() throws Exception {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.numPoints; ++i) {
            if (!(this.avail.GetElement(i, i) + this.resp.GetElement(i, i) > 0.0)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    Integer GetNearestExamplar(int n, ArrayList<Integer> arrayList) throws Exception {
        double d = Double.NEGATIVE_INFINITY;
        Integer n2 = new Integer(-1);
        for (Integer n3 : arrayList) {
            try {
                double d2 = this.similarities.GetElement(n, n3);
                if (!(d2 > d)) continue;
                n2 = n3;
            }
            catch (Exception exception) {
                System.out.println("Exception in GetNearestExamplar ");
                exception.printStackTrace();
            }
        }
        return n2;
    }

    Integer[] GetNeighborExamplars(int n, ArrayList<Integer> arrayList) throws Exception {
        Integer[] integerArray = new Integer[]{new Integer(-1), new Integer(-1)};
        for (Integer n2 : arrayList) {
            if (n2 <= n) {
                integerArray[0] = n2;
                continue;
            }
            integerArray[1] = n2;
            break;
        }
        return integerArray;
    }

    public TreeMap<Integer, TreeSet<Integer>> GetAssignments() throws Exception {
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < this.getNumPoints(); ++i) {
            Integer n = new Integer(this.GetMostLikelyExamplar(i));
            if (treeMap.containsKey(n)) {
                ((TreeSet)treeMap.get(n)).add(new Integer(i));
                continue;
            }
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            treeSet.add(new Integer(i));
            treeMap.put(n, treeSet);
        }
        this.assignments = treeMap;
        return this.assignments;
    }

    public TreeMap<Integer, TreeSet<Integer>> GetNonConflictingAssignments() throws Exception {
        TreeMap<Integer, TreeSet<Integer>> treeMap = this.GetAssignments();
        TreeMap<Integer, Object> treeMap2 = new TreeMap<Integer, Object>();
        ArrayList<Integer> arrayList = this.GetExamplars();
        if (arrayList == null || arrayList.size() <= 0) {
            System.out.println("NO EXAMPLARS FOUND");
            return null;
        }
        for (int i = 0; i < this.getNumPoints(); ++i) {
            try {
                Serializable serializable;
                Object object;
                Integer n = this.GetMostLikelyExamplar(i);
                if (arrayList.contains(n)) {
                    if (treeMap2.containsKey(n)) {
                        ((TreeSet)treeMap2.get(n)).add(new Integer(i));
                        continue;
                    }
                    object = new TreeSet();
                    ((TreeSet)object).add(new Integer(i));
                    treeMap2.put(n, object);
                    continue;
                }
                object = this.GetNeighborExamplars(i, arrayList);
                Integer n2 = object[0];
                Integer n3 = object[1];
                double d = Double.NEGATIVE_INFINITY;
                double d2 = Double.NEGATIVE_INFINITY;
                TreeSet<Object> treeSet = new TreeSet();
                TreeSet<Object> treeSet2 = new TreeSet();
                if (n2 > -1) {
                    try {
                        d = this.similarities.GetElement(i, n2);
                        treeSet = treeMap.get(n2);
                    }
                    catch (Exception exception) {}
                } else {
                    d = Double.NEGATIVE_INFINITY;
                }
                if (n3 > -1) {
                    try {
                        d2 = this.similarities.GetElement(i, n3);
                        treeSet2 = treeMap.get(n3);
                    }
                    catch (Exception exception) {
                        System.out.println("point " + String.valueOf(i) + "cannot be assigned to examplar " + n2.toString());
                    }
                } else {
                    d2 = Double.NEGATIVE_INFINITY;
                }
                n = -1;
                n = d >= d2 ? (n3 > -1 && treeSet2.size() > 0 ? ((Integer)(serializable = (Integer)treeSet2.first()) > i ? n2 : n3) : n2) : (n2 > -1 && treeSet.size() > 0 ? ((Integer)(serializable = (Integer)treeSet.last()) < i ? n3 : n2) : n3);
                if (treeMap2.containsKey(n)) {
                    ((TreeSet)treeMap2.get(n)).add(new Integer(i));
                    continue;
                }
                serializable = new TreeSet();
                ((TreeSet)serializable).add(new Integer(i));
                treeMap2.put(n, serializable);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Exception in GetNonConflictingAssignments " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        this.assignments = treeMap2;
        return this.assignments;
    }

    public void PrintAssignments() {
        if (this.assignments == null) {
            System.out.println("Assignments have not been initialized");
            return;
        }
        for (Integer n : this.assignments.keySet()) {
            System.out.print("\nExamplar " + n.toString() + ": ");
            for (Integer n2 : this.assignments.get(n)) {
                System.out.print(n2.toString() + ", ");
            }
        }
        System.out.println();
    }

    int GetMostLikelyExamplar(int n) throws Exception {
        double d = Double.NEGATIVE_INFINITY;
        int n2 = -1;
        int n3 = this.similarities.GetRowStart(n);
        int n4 = this.similarities.GetRowEnd(n);
        for (int i = n3; i <= n4; ++i) {
            double d2 = this.resp.GetElement(n, i) + this.avail.GetElement(n, i);
            if (!(d2 > d)) continue;
            n2 = i;
            d = d2;
        }
        return n2;
    }

    public void AddNoise() throws Exception {
        double[][] dArray = new double[this.similarities.GetNumRows()][this.similarities.GetNumColumns()];
        this.CreateNoiseMatrix(dArray);
        for (int i = 0; i < this.similarities.GetNumRows(); ++i) {
            for (int j = 0; j < this.similarities.GetNumColumns(); ++j) {
                double d = this.similarities.GetElement(i, j) + dArray[i][j];
                this.similarities.SetElement(i, j, d);
            }
        }
        dArray = null;
        System.out.print("done");
    }

    public void PrintMatrix(double[][] dArray, double[][] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            String string;
            int n;
            int n2;
            double d = 0.0;
            int n3 = -1;
            System.out.print("ROW " + String.valueOf(i) + ":\n\tResp: ");
            for (n2 = 0; n2 < dArray[0].length; ++n2) {
                n = n2 + this.similarities.GetRowStart(i);
                string = String.format(" : %.3f, ", Float.valueOf(String.valueOf(dArray[i][n2])));
                System.out.print(String.valueOf(n) + string);
            }
            System.out.print("\n\tAvail: ");
            for (n2 = 0; n2 < dArray2[0].length; ++n2) {
                n = n2 + this.similarities.GetRowStart(i);
                string = String.format(" : %.3f, ", Float.valueOf(String.valueOf(dArray2[i][n2])));
                System.out.print(String.valueOf(n) + string);
            }
            System.out.print("\n\tSum: ");
            n2 = -1;
            for (n = 0; n < dArray2[0].length; ++n) {
                int n4 = n + this.similarities.GetRowStart(i);
                double d2 = dArray2[i][n] + dArray[i][n];
                if (n == 0) {
                    d = d2;
                    n3 = n;
                } else if (d2 > d) {
                    d = d2;
                    n3 = n;
                }
                n2 = n3 + this.similarities.GetRowStart(i);
                String string2 = String.format(" : %.3f, ", Float.valueOf(String.valueOf(d2)));
                System.out.print(String.valueOf(n4) + string2);
            }
            String string3 = String.format(" : %.3f at %d ", Float.valueOf(String.valueOf(d)), n2);
            System.out.println("\n\tMax: " + string3);
        }
    }

    private void CreateNoiseMatrix(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                double d;
                double d2 = 1.0E-12;
                double d3 = Math.random();
                double d4 = this.maxSim - this.minSim;
                dArray[i][j] = d = d2 * d3 * d4;
            }
        }
    }

    int GetCurrentConvergenceCount() {
        return this.convergenceCount;
    }

    void SetCurrentConvergenceCount(int n) {
        this.convergenceCount = n;
    }

    void IncrementConvergenceCount() {
        ++this.convergenceCount;
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public void setNumPoints(int n) {
        this.numPoints = n;
    }

    public double getDampFactor() {
        return this.dampFactor;
    }

    public void setDampFactor(double d) {
        this.dampFactor = d;
    }

    public double getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int n) {
        this.maxIterations = n;
    }

    public int getMaxConvCount() {
        return this.maxConvCount;
    }

    public void setMaxConvCount(int n) {
        this.maxConvCount = n;
    }

    private class WorkerThread
    extends Thread {
        private AbstractAPSegmenterDP parent;
        private int startRow;
        private int startCol;
        private int endRow;
        private int endCol;
        private boolean calcResp;

        public WorkerThread(AbstractAPSegmenterDP abstractAPSegmenterDP2, boolean bl, int n, int n2) {
            this.parent = abstractAPSegmenterDP2;
            this.startRow = this.startCol = n;
            this.endRow = this.endCol = n2;
            this.calcResp = bl;
        }

        @Override
        public void run() {
            try {
                if (this.calcResp) {
                    int[] nArray = new int[2];
                    for (int i = this.startRow; i <= this.endRow; ++i) {
                        nArray[1] = -1;
                        nArray[0] = -1;
                        int n = this.parent.similarities.GetRowStart(i);
                        int n2 = this.parent.similarities.GetRowEnd(i);
                        for (int j = n; j <= n2; ++j) {
                            this.parent.CalcResponsibility(i, j, nArray);
                        }
                    }
                } else {
                    for (int i = this.startCol; i <= this.endCol; ++i) {
                        int n = this.parent.similarities.GetColumnStart(i);
                        int n3 = this.parent.similarities.GetColumnEnd(i);
                        for (int j = n; j <= n3; ++j) {
                            this.parent.CalcAvailability(j, i);
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Exception in worker thread" + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }
}

