#!/usr/bin/perl

print STDERR "reading data...";
while (<>) {
  next if /final/;
  if (/^([0-9]+)\t<([0-9]+)>\t/) {
    if (!exists $symbol{$1} || $symbol{$1} > $2) {
      $symbol{$1} = $2;
    }
  }
  else { 
    push @trans, $_;
  }
}

print STDERR "finished\nsorting...";
foreach $t (sort compare @trans) {
  print $t;
}

foreach $s (sort {$a <=> $b} keys %symbol) {
  print "$s\twordclass\t$symbol{$s}\n";
}
print STDERR "finished\n";


sub compare {
  my @A=split(/\t/,$a);
  my @B=split(/\t/,$b);
  return ($A[0]-$B[0] || $A[1] cmp $B[1]);
}
