/*
 * Decompiled with CFR 0.152.
 */
package tsg.utils;

import java.io.File;
import java.util.ArrayList;
import tsg.TSNodeLabel;

public class CountInternalNodes {
    public static void main(String[] args) throws Exception {
        File inputTreebank = new File(args[0]);
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(inputTreebank);
        int total = 0;
        for (TSNodeLabel t : treebank) {
            total += t.countNonLexicalNodes();
        }
        System.out.println("Total trees: " + treebank.size());
        System.out.println("Total non-lexical nodes: " + total);
    }

    public int countInternalNodes(TSNodeLabel n) {
        if (n.isPreLexical()) {
            return 0;
        }
        int result = n.parent == null ? 0 : 1;
        TSNodeLabel[] tSNodeLabelArray = n.daughters;
        int n2 = n.daughters.length;
        int n3 = 0;
        while (n3 < n2) {
            TSNodeLabel d = tSNodeLabelArray[n3];
            result += this.countInternalNodes(d);
            ++n3;
        }
        return result;
    }
}

