/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.ListIterator;
import kernels.NodeSetCollectorSimple;
import kernels.NodeSetCollectorUnion;
import tsg.TSNodeLabel;
import tsg.TSNodeLabelIndex;
import tsg.TSNodeLabelStructure;
import tsg.kernels.CommonStructures;
import tsg.kernels.CommonSubtrees;

public class CommonSubtreesMUBThreads
extends CommonSubtrees {
    public CommonSubtreesMUBThreads(ArrayList<TSNodeLabelStructure> treebank, int threads, int startIndex) {
        super(treebank, threads, startIndex);
    }

    @Override
    protected void initiateThreadArray() {
        this.threadsArray = new CountFragmentsThread[this.threads];
        int i = 0;
        while (i < this.threads) {
            this.threadsArray[i] = new CountFragmentsThread();
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
    }

    private class CountFragmentsThread
    extends CommonStructures.CommonStructuresThread {
        HashSet<TSNodeLabel> fragmentSet = new HashSet();

        @Override
        protected void collectCommonFragments(TSNodeLabelStructure[] trees) {
            TSNodeLabelStructure[] tSNodeLabelStructureArray = trees;
            int n = trees.length;
            int n2 = 0;
            while (n2 < n) {
                TSNodeLabelStructure t1 = tSNodeLabelStructureArray[n2];
                if (t1 == null) break;
                this.startIndex[0] = this.startIndex[0] + 1;
                ListIterator iter = CommonSubtreesMUBThreads.this.treebank.listIterator(this.startIndex[0]);
                NodeSetCollectorSimple intermediateCollector = new NodeSetCollectorSimple();
                while (iter.hasNext()) {
                    TSNodeLabelStructure t2 = (TSNodeLabelStructure)iter.next();
                    NodeSetCollectorUnion[][] CST = CommonSubtreesMUBThreads.getCST(t1, t2);
                    CommonSubtreesMUBThreads.extractSubTreesIntermediate(CST, intermediateCollector);
                }
                this.extractSubTreesInTableThread(intermediateCollector, t1);
                ++n2;
            }
        }

        private void extractSubTreesInTableThread(NodeSetCollectorSimple intermediateCollector, TSNodeLabelStructure s) {
            for (BitSet bs : intermediateCollector.bitSetSet) {
                TSNodeLabelIndex rootNode = s.structure[bs.nextSetBit(0)];
                TSNodeLabel fragment = rootNode.getSubTree(bs);
                this.fragmentSet.add(fragment);
            }
        }

        @Override
        protected void printFragmentsToFile(BufferedWriter fileWriter) throws IOException {
            for (TSNodeLabel fragment : this.fragmentSet) {
                String fragmetnFreqString = String.valueOf(fragment.toString(false, true)) + "\t1";
                fileWriter.write(String.valueOf(fragmetnFreqString) + "\n");
            }
        }

        @Override
        protected void clearFragmentBank() {
            this.fragmentSet.clear();
        }
    }
}

