DEFAULT_SYSTEM_PROMPT = """\
You are a helpful, respectful and honest assistant. Always answer as helpfully as possible, while being safe.  Your answers should not include any harmful, unethical, racist, sexist, toxic, dangerous, or illegal content. Please ensure that your responses are socially unbiased and positive in nature.

If a question does not make any sense, or is not factually coherent, explain why instead of answering something not correct. If you don't know the answer to a question, please don't share false information."""



_system_prompt_evaluate = "You are an assistant who is given a document followed by a summary based on an aspect of the document. You are tasked with evaluating the factuality of the summary. Always answer as helpfully as possible, while being safe.  Your answers should not include any harmful, unethical, racist, sexist, toxic, dangerous, or illegal content. Please ensure that your responses are socially unbiased and positive in nature."


_simple_no_format_template = """Document:
{document}

Summary:

{summary}
-----

The provided summary is factually inconsistent with the corresponding document. This implies that there is information in the summary that is NOT substantiated by the document.
Identify factual inconsistencies in the summary and give feedback on how to improve them. The feedback should be helpful and should give specific suggestions to improve the summary."""

_simple_no_format_template_no_revision = """Document:
{document}

Summary:

{summary}
-----

The provided summary is factually inconsistent with the corresponding document. This implies that there is information in the summary that is NOT substantiated by the document.
Identify factual inconsistencies in the summary and give feedback on how to improve them. The feedback should be helpful and should give specific suggestions to improve the summary. Only give the feedback, do not rewrite the summary."""


_simple_no_format_aspect_template = """Document to be summarized:
{document}

Summary from the document on the topic '{aspect}':

{summary}
-----

The provided summary is factually inconsistent with the corresponding document. This implies that there is information in the summary that is NOT substantiated by the document.
Identify factual inconsistencies in the summary and give feedback on how to improve them. The feedback should be helpful and should give specific suggestions to improve the summary."""


_simple_no_format_aspect_explicit_no_revision = """Document to be summarized:
{document}

Summary from the document on the topic '{aspect}':

{summary}
-----

The provided summary is factually inconsistent with the corresponding document. This implies that there is information in the summary that is NOT substantiated by the document.
Identify factual inconsistencies in the summary and give feedback on how to improve them. The feedback should be helpful and should give specific suggestions to improve the summary. Only give the feedback, do not rewrite the summary."""

_gpt4_categories_no_format_template = """Document:
{document}

Summary:

{summary}
-----

The provided summary is factually inconsistent with the corresponding document. This implies that there is information in the summary that is NOT substantiated by the document. Factual inconsistencies can be of the following types:
1. Mis-Referencing: a property or an event in the summary can be found in the document, but are associated with the wrong entity
2. Stating Opinion As Fact: the summary entails a proposition that's mentioned in the document not as a fact, but as someone's opinion
3. Reasoning Error: the summary makes one or more wrong inferences from the information in the document
4. Tense/modality Error: the tense or modal (eg: can, may, must) used in the summary does not match the tense/modality of the document
5. Extrinsic Information: the summary contains new information not grounded in the source document
6. Contradiction: the summary contradicts the document
7. Nuanced Meaning Shift: the summary twists information from the document in a subtle way

Given the document and the summary, your task is to identify factual inconsistencies and give feedback on how to improve them. The feedback should be helpful and should give specific suggestions to improve the summary."""


_gpt4_categories_json_template = """Document:
{document}

Summary:

{summary}
-----

The provided summary is factually inconsistent with the corresponding document. This implies that there is information in the summary that is NOT substantiated by the document. Factual inconsistencies can be of the following types:
1. Extrinsic Information: the summary contains new information not grounded in the source document
2. Mis-Referencing: a property or an event in the summary can be found in the document, but are associated with the wrong entity
3. Stating Opinion As Fact: the summary entails a proposition that's mentioned in the document not as a fact, but as someone's opinion
4. Reasoning Error: the summary makes one or more wrong inferences from the information in the document
5. Tense/modality Error: the tense or modal (eg: can, may, must) used in the summary does not match the tense/modality of the document
6. Contradiction: the summary contradicts the document
7. Nuanced Meaning Shift: the summary twists information from the document in a subtle way

Given the document and the summary, your task is to identify these factual inconsistencies and give feedback on how to improve them.

Identify the factually inconsistent information in the summary and for each inconsistency identify the inconsistency type and give a feedback that is a helpful and specific suggestion to improve the inconsistency. Return a list where each element is a JSON with the following keys:
1. inconsistency
2. inconsistency type
3. feedback"""

_gpt4_categories_json_only_template = """Document:
{document}

Summary:

{summary}
-----

The provided summary is factually inconsistent with the corresponding document. This implies that there is information in the summary that is NOT substantiated by the document. Factual inconsistencies can be of the following types:
1. Extrinsic Information: the summary contains new information not grounded in the source document
2. Mis-Referencing: a property or an event in the summary can be found in the document, but are associated with the wrong entity
3. Stating Opinion As Fact: the summary entails a proposition that's mentioned in the document not as a fact, but as someone's opinion
4. Reasoning Error: the summary makes one or more wrong inferences from the information in the document
5. Tense/modality Error: the tense or modal (eg: can, may, must) used in the summary does not match the tense/modality of the document
6. Contradiction: the summary contradicts the document
7. Nuanced Meaning Shift: the summary twists information from the document in a subtle way

Your task is to identify these factual inconsistencies in the summary and give feedback on how to improve them.

Identify the factually inconsistent information in the summary and for each inconsistency identify the inconsistency type and give a feedback that is a helpful and specific suggestion to improve the inconsistency. Give your answer in JSON format only. Do not include a preamble.
"""


_gpt4_categories_json_only_turns_template = """Please summarize the document with respect to the given aspect:

Aspect: {aspect}

Document:
{document}
[/INST]

{summary}
</s><s>[INST]
The provided summary is factually inconsistent with the corresponding document. This implies that there is information in the summary that is NOT substantiated by the document. Factual inconsistencies can be of the following types:
1. Extrinsic Information: the summary contains new information not grounded in the source document
2. Mis-Referencing: a property or an event in the summary can be found in the document, but are associated with the wrong entity
3. Stating Opinion As Fact: the summary entails a proposition that's mentioned in the document not as a fact, but as someone's opinion
4. Reasoning Error: the summary makes one or more wrong inferences from the information in the document
5. Tense/modality Error: the tense or modal (eg: can, may, must) used in the summary does not match the tense/modality of the document
6. Contradiction: the summary contradicts the document
7. Nuanced Meaning Shift: the summary twists information from the document in a subtle way

Your task is to identify these factual inconsistencies in the summary and give feedback on how to improve them.

Identify the factually inconsistent information in the summary and for each inconsistency identify the inconsistency type and give a feedback that is a helpful and specific suggestion to improve the inconsistency. Give your answer in JSON format only. Do not include a preamble.
"""


_categories_json_summary_last = """
Document:

{{document}}

-----

The provided summary below is factually inconsistent with the document above. This implies that there is information in the summary that is NOT substantiated by the document. Factual inconsistencies can be of the following types:
1. Extrinsic Information: the summary contains new information not grounded in the source document
2. Mis-Referencing: a property or an event in the summary can be found in the document, but are associated with the wrong entity
3. Stating Opinion As Fact: the summary entails a proposition that's mentioned in the document not as a fact, but as someone's opinion
4. Reasoning Error: the summary makes one or more wrong inferences from the information in the document
5. Tense/modality Error: the tense or modal (eg: can, may, must) used in the summary does not match the tense/modality of the document
6. Contradiction: the summary contradicts the document
7. Nuanced Meaning Shift: the summary twists information from the document in a subtle way

Your task is to identify these factual inconsistencies in the summary and give feedback on how to improve them.

Identify the factually inconsistent information in the summary and for each inconsistency identify the inconsistency type and give a feedback that is a helpful and specific suggestion to improve the inconsistency. Give your answer in JSON format only. Do not include a preamble.
{example_output}

-----

PLease give feedback on the following summary:

{{summary}}

"""


_categories_step_by_step_summary_last = """
Document:

{document}

-----

The provided summary below is factually inconsistent with the document above. This implies that there is information in the summary that is NOT substantiated by the document. Factual inconsistencies can be of the following types:
1. Extrinsic Information: the summary contains new information not grounded in the source document
2. Mis-Referencing: a property or an event in the summary can be found in the document, but are associated with the wrong entity
3. Stating Opinion As Fact: the summary entails a proposition that's mentioned in the document not as a fact, but as someone's opinion
4. Reasoning Error: the summary makes one or more wrong inferences from the information in the document
5. Tense/modality Error: the tense or modal (eg: can, may, must) used in the summary does not match the tense/modality of the document
6. Contradiction: the summary contradicts the document
7. Nuanced Meaning Shift: the summary twists information from the document in a subtle way

Your task is to identify these factual inconsistencies in the summary and give feedback on how to improve them.

For each sentence in the summary, explain step-by-step whether the summary sentence contains a factual inconsistency. Then provide feedback on how to fix it.

-----

PLease give feedback on the sentences from the following summary:

{summary}
"""


_categories_step_by_step_whole_summary_last = """
Document:

{document}

-----

The provided summary below is factually inconsistent with the document above. This implies that there is information in the summary that is NOT substantiated by the document. Factual inconsistencies can be of the following types:
1. Extrinsic Information: the summary contains new information not grounded in the source document
2. Mis-Referencing: a property or an event in the summary can be found in the document, but are associated with the wrong entity
3. Stating Opinion As Fact: the summary entails a proposition that's mentioned in the document not as a fact, but as someone's opinion
4. Reasoning Error: the summary makes one or more wrong inferences from the information in the document
5. Tense/modality Error: the tense or modal (eg: can, may, must) used in the summary does not match the tense/modality of the document
6. Contradiction: the summary contradicts the document
7. Nuanced Meaning Shift: the summary twists information from the document in a subtle way

Your task is to identify these factual inconsistencies in the summary and give feedback on how to improve them.

Explain step-by-step what factual inconsistencies the summary contains, if any. Then provide feedback on how to fix the factual inconsistencies that exist.

-----

PLease give feedback on the sentences from the following summary:

{summary}
"""


_categories_step_by_step = """
Document:

{document}

Summary:

{summary}

-----

The provided summary is factually inconsistent with the document above. This implies that there is information in the summary that is NOT substantiated by the document. Factual inconsistencies can be of the following types:
1. Extrinsic Information: the summary contains new information not grounded in the source document
2. Mis-Referencing: a property or an event in the summary can be found in the document, but are associated with the wrong entity
3. Stating Opinion As Fact: the summary entails a proposition that's mentioned in the document not as a fact, but as someone's opinion
4. Reasoning Error: the summary makes one or more wrong inferences from the information in the document
5. Tense/modality Error: the tense or modal (eg: can, may, must) used in the summary does not match the tense/modality of the document
6. Contradiction: the summary contradicts the document
7. Nuanced Meaning Shift: the summary twists information from the document in a subtle way

Your task is to identify these factual inconsistencies in the summary and give feedback on how to improve them.

For each sentence in the summary, explain step-by-step whether the summary sentence contains a factual inconsistency. Then provide feedback on how to fix it.

"""


_example_output = """Example output:
[
{{
"inconsistency": "<span from the summary>",
"inconsistency type": <the inconsistency type from the above list of types>,
"feedback": "<explanation of the error and how it can be fixed>"
}},
]
"""


_example_output_with_eg = """Example output:
[
{{
"inconsistency": "<span from the summary>",  
"inconsistency type": <the inconsistency type from the above list of types, e.g. "Extrinsic Information">,
"feedback": "<explanation of the error and how it can be fixed>"
}},
]
"""


_example_output_with_eg_below = """Example output:
[
{{
"inconsistency": "<span from the summary below>",
"inconsistency type": <the inconsistency type from the above list of types, e.g. "Extrinsic Information">,
"feedback": "<explanation of the error and how it can be fixed>"
}},
]"""



_categories_step_by_step_summary_last_document_text = """
Document:

{{document}}

-----

The provided summary below is factually inconsistent with the document above. This implies that there is information in the summary that is NOT substantiated by the document. Factual inconsistencies can be of the following types:
1. Extrinsic Information: the summary contains new information not grounded in the source document
2. Mis-Referencing: a property or an event in the summary can be found in the document, but are associated with the wrong entity 
3. Stating Opinion As Fact: the summary entails a proposition that's mentioned in the document not as a fact, but as someone's opinion 
4. Reasoning Error: the summary makes one or more wrong inferences from the information in the document
5. Tense/modality Error: the tense or modal (eg: can, may, must) used in the summary does not match the tense/modality of the document
6. Contradiction: the summary contradicts the document
7. Nuanced Meaning Shift: the summary twists information from the document in a subtle way 

Your task is to identify these factual inconsistencies in the summary and give feedback on how to improve them.

For each sentence in the summary, identify the text from the document that the sentence summarizes. Then explain step-by-step whether the summary sentence contains a factual inconsistency. Identify the inconsistency type if one exists and then provide feedback on how to fix it.
Give your answer in JSON format only. Do not include a preamble.

{example_output}

-----

PLease give feedback on the sentences from the following summary:

{{summary}}
"""


_example_output_document_text = """Example output:
[
{{
"summary text": "<sentence from the summary below>",
"document text": "<information from the document that relates to the summary sentence>",
"inconsistency type": <the inconsistency type from the above list of types, e.g. "Extrinsic Information", or "None">,
"feedback": "<explanation of the error and how to fix it, or "None">",
}},
]"""


_categories_step_by_step_summary_last_reasoning = """
Document:

{{document}}

-----

The provided summary below is factually inconsistent with the document above. This implies that there is information in the summary that is NOT substantiated by the document. Factual inconsistencies can be of the following types:
1. Extrinsic Information: the summary contains new information not grounded in the source document
2. Mis-Referencing: a property or an event in the summary can be found in the document, but are associated with the wrong entity 
3. Stating Opinion As Fact: the summary entails a proposition that's mentioned in the document not as a fact, but as someone's opinion 
4. Reasoning Error: the summary makes one or more wrong inferences from the information in the document
5. Tense/modality Error: the tense or modal (eg: can, may, must) used in the summary does not match the tense/modality of the document
6. Contradiction: the summary contradicts the document
7. Nuanced Meaning Shift: the summary twists information from the document in a subtle way 

Your task is to identify these factual inconsistencies in the summary and give feedback on how to improve them.

For each sentence in the summary, identify the text from the document that the sentence summarizes. Then explain step-by-step whether the summary sentence contains a factual inconsistency. Identify the inconsistency type if one exists and then provide feedback on how to fix it.
Give your answer in JSON format only. Do not include a preamble.

{example_output}

-----

PLease give feedback on the sentences from the following summary:

{{summary}}
"""


_example_output_reasoning = """Example output:
[
{{
"summary text": "<sentence from the summary below>",
"reasoning": "<how the summary text relates to information from the document>",
"inconsistency type": <the inconsistency type from the above list of types, e.g. "Extrinsic Information", or "None">,
"feedback": "<explanation of the error and how to fix it, or "None">",
}},
]"""


_replace_parenthesized = {
    "1 (Extrinsic Information)": "1",
    "2 (Mis-Referencing)": "2",
    "3 (Stating Opinion As Fact)": "3",
    "4 (Reasoning Error)": "4",
    "5 (Tense/modality Error)": "5",
    "6 (Contradiction)": "6",
    "7 (Nuanced Meaning Shift)": "7",
}


def gpt4_categories_json_parser(raw_output: str):
    parsed = raw_output.strip()
    try:
        parsed = parsed.split("[")[1]
        parsed = parsed.split("]")[0]
        parsed = f"[{parsed}]"
        for k, v in _replace_parenthesized.items():
            parsed = parsed.replace(k, v)
            parsed = parsed.replace(k.lower(), v)
        eval(parsed)
    except:
        print(parsed)
        return None
    return parsed


TEMPLATES = {
    "simple_no_format": {
        "prompt": _simple_no_format_template,
        "output_type": str,
    },
    "simple_no_format_no_revision":{
        "prompt":_simple_no_format_template_no_revision,
        "output_type":str
    },
    "simple_no_format_aspect": {
        "prompt": _simple_no_format_aspect_template,
        "output_type": str,
    },
    "simple_no_format_aspect_explicit_no_revision": {
        "prompt": _simple_no_format_aspect_explicit_no_revision,
        "output_type": str,
    },
    "gpt4_categories_no_format": {
        "system_prompt": DEFAULT_SYSTEM_PROMPT,
        "prompt": _gpt4_categories_no_format_template,
        "output_type": str,
        "parser": lambda x: x,
    },
    "gpt4_categories_json": {
        "system_prompt": DEFAULT_SYSTEM_PROMPT,
        "prompt": _gpt4_categories_json_template,
        "output_type": "json",
        "parser": gpt4_categories_json_parser,
    },
    "gpt4_categories_json_generation_start": {
        "system_prompt": DEFAULT_SYSTEM_PROMPT,
        "prompt": _gpt4_categories_json_template,
        "output_type": "json",
        "parser": gpt4_categories_json_parser,
        "generation_start": """
[
{
    "inconsistency":""",
    },
    "gpt4_categories_json_generation_start_2": {
        "system_prompt": DEFAULT_SYSTEM_PROMPT,
        "prompt": _gpt4_categories_json_template.replace(
            "Given the document and the summary, your task is to identify these factual inconsistencies",
            "Your task is to identify these factual inconsistencies in the summary",
        ),
        "output_type": "json",
        "parser": gpt4_categories_json_parser,
        "generation_start": """
[
{
    "inconsistency":""",
    },
    "gpt4_categories_json_with_example": {
        "system_prompt": DEFAULT_SYSTEM_PROMPT,
        "prompt": _gpt4_categories_json_only_template + _example_output,
        "output_type": "json",
        "parser": gpt4_categories_json_parser,
    },
    "gpt4_categories_json_with_example_generation_start": {
        "system_prompt": DEFAULT_SYSTEM_PROMPT,
        "prompt": _gpt4_categories_json_only_template + _example_output,
        "output_type": "json",
        "parser": gpt4_categories_json_parser,
        "generation_start": """
[
{
    "inconsistency":""",
    },
    "gpt4_categories_json_with_example_eg_generation_start": {
        "system_prompt": DEFAULT_SYSTEM_PROMPT,
        "prompt": _gpt4_categories_json_only_template + _example_output_with_eg,
        "output_type": "json",
        "parser": gpt4_categories_json_parser,
        "generation_start": """
[
{
    "inconsistency":""",
    },
    "gpt4_categories_json_with_example_eg_turns_generation_start": {
        "system_prompt": DEFAULT_SYSTEM_PROMPT,
        "prompt": _gpt4_categories_json_only_turns_template + _example_output_with_eg,
        "output_type": "json",
        "parser": gpt4_categories_json_parser,
        "generation_start": """
[
{
    "inconsistency":""",
    },
    "gpt4_categories_json_with_example_eg_generation_start_system_prompt_evaluate": {
        "system_prompt": _system_prompt_evaluate,
        "prompt": _gpt4_categories_json_only_template + _example_output_with_eg,
        "output_type": "json",
        "parser": gpt4_categories_json_parser,
        "generation_start": """
[
{
    "inconsistency":""",
    },
    "categories_json_with_example_eg_generation_summary_last": {
        "prompt": _categories_json_summary_last.format(example_output=_example_output_with_eg_below),
        "output_type": "json",
        "parser": gpt4_categories_json_parser,
        "generation_start": """
[
{
    "inconsistency":""",
    },
    "categories_step_by_step_summary_last": {
        "prompt": _categories_step_by_step_summary_last,
        "output_type": "string",
        "parser": lambda x: x,
    },
    "categories_step_by_step": {
        "prompt": _categories_step_by_step,
        "output_type": "string",
        "parser": lambda x: x,
    },
    "categories_step_by_step_whole_summary_last": {
        "prompt": _categories_step_by_step_whole_summary_last,
        "output_type": "string",
        "parser": lambda x: x,
    },
    "categories_step_by_step_summary_last_document_text": {
        "prompt": _categories_step_by_step_summary_last_document_text.format(example_output=_example_output_document_text),
        "output_type": "json",
        "parser": gpt4_categories_json_parser,
        "generation_start": """
[
{
    "summary text":"""
    },
    "categories_step_by_step_summary_last_reasoning": {
        "prompt": _categories_step_by_step_summary_last_reasoning.format(example_output=_example_output_reasoning),
        "output_type": "json",
        "parser": gpt4_categories_json_parser,
        "generation_start": """
[
{
    "summary text":"""
    },
}

