/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.Datum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BasicDatum<LabelType, FeatureType>
implements Datum<LabelType, FeatureType> {
    private final Collection<FeatureType> features;
    private final List<LabelType> labels = new ArrayList<LabelType>();
    private static final long serialVersionUID = -4857004070061779966L;

    public BasicDatum(Collection<FeatureType> features, Collection<LabelType> labels) {
        this(features);
        this.setLabels(labels);
    }

    public BasicDatum(Collection<FeatureType> features, LabelType label) {
        this(features);
        this.setLabel(label);
    }

    public BasicDatum(Collection<FeatureType> features) {
        this.features = features;
    }

    public BasicDatum() {
        this(null);
    }

    @Override
    public Collection<FeatureType> asFeatures() {
        return this.features;
    }

    @Override
    public LabelType label() {
        return this.labels.size() > 0 ? (LabelType)this.labels.get(0) : null;
    }

    @Override
    public Collection<LabelType> labels() {
        return this.labels;
    }

    public void setLabel(LabelType label) {
        this.labels.clear();
        this.addLabel(label);
    }

    public void setLabels(Collection<LabelType> labels) {
        this.labels.clear();
        if (labels != null) {
            this.labels.addAll(labels);
        }
    }

    public void addLabel(LabelType label) {
        if (label != null) {
            this.labels.add(label);
        }
    }

    public String toString() {
        return "BasicDatum[features=" + this.asFeatures() + ",labels=" + this.labels() + "]";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Datum)) {
            return false;
        }
        Datum d = (Datum)o;
        return ((Object)this.features).equals(d.asFeatures());
    }

    public int hashCode() {
        return ((Object)this.features).hashCode();
    }
}

