#!/bin/bash

# Running all the experiments in the paper

# Base command
BASE_CMD="python scripts/estimation.py"

# Language experiments

# Proportional sampling
$BASE_CMD --metric accuracy --datatype language --mingroupsize 10 --sampling prop

# Equal sampling
$BASE_CMD --metric accuracy --datatype language --mingroupsize 10 --sampling equal
$BASE_CMD --metric accuracy --datatype language --mingroupsize 20 --sampling equal
$BASE_CMD --metric accuracy --datatype language --mingroupsize 50 --sampling equal

# Compute confidence intervals (will overwrite existing files)
$BASE_CMD --metric accuracy --datatype language --mingroupsize 10 --sampling prop --compute_cis

# Run experiments for other metrics
$BASE_CMD --metric other --datatype language --mingroupsize 10 --sampling equal
$BASE_CMD --metric other --datatype language --mingroupsize 20 --sampling equal
$BASE_CMD --metric other --datatype language --mingroupsize 50 --sampling equal

# Run experiments on other datatypes
$BASE_CMD --metric accuracy --datatype vision --mingroupsize 20 --sampling equal
$BASE_CMD --metric accuracy --datatype vision --mingroupsize 10 --sampling prop

# Consolidate results
python scripts/consolidate_results.py