theory question_81_6
imports Main

begin

typedecl entity

consts
  Soil :: "entity ⇒ bool"
  Nonliving :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  Forest :: "entity ⇒ bool"

(* Explanation: Soil is a nonliving part of a forest. *)
axiomatization where
  explanation_1: "Soil x ⟹ Nonliving x ∧ PartOf x y ⟹ Forest y"

theorem hypothesis:
  assumes asm: "Soil x"
  (* Hypothesis: Soil is a nonliving part of a forest. *)
  shows "Nonliving x ∧ PartOf x  Forest x"
proof -
  from asm have "Soil x" and "Nonliving x" using explanation_1 by blast
  then have "PartOf x Forest x" using explanation_1 by blast
  show ?thesis using asm "Nonliving x" "PartOf x Forest x" by blast
qed

end
