theory question_77_6

imports Main

begin

typedecl entity

consts
  Matter :: "entity ⇒ bool"
  Mass :: "entity ⇒ bool"
  Volume :: "entity ⇒ bool"
  Aluminum :: "entity ⇒ bool"
  Copper :: "entity ⇒ bool"
  SameType :: "entity ⇒ entity ⇒ bool"

(* Explanation: Matter has mass and volume. *)
axiomatization where
  explanation: "∃x. Matter x ⟶ (Mass x ∧ Volume x)"

(* Explanation: Aluminum and copper are different types of matter. *)
axiomatization where
  explanation_2: "∀x y. Aluminum x ∧ Copper y ∧ ¬SameType x y"

theorem hypothesis:
  (* Premise: Aluminum and copper are composed of different types of matter. *)
  assumes asm: "Aluminum x ∧ Copper y ∧ ¬SameType x y"
  (* Hypothesis: Matter has mass and volume. *)
  shows "∃x. Matter x ∧  Mass x ∧ Volume x "
proof -
  fix x
  assume asm: "Matter x"
  then have "Mass x ∧ Volume x"
  using explanation by blast
  then show "Matter x ∧ Mass x ∧ Volume x" by simp
qed

end
