theory question_90_6

imports Main

begin

typedecl entity
typedecl event

consts
  Peat :: "entity ⇒ bool"
  SoilAndMud :: "entity ⇒ bool"
  Wetlands :: "entity ⇒ bool"
  BuriedUnder :: "event ⇒ entity ⇒ entity ⇒ bool"
  ExtremeHeatAndPressure :: "event ⇒ bool"
  Coal :: "entity ⇒ bool"

(* Explanation 1: Peat, buried under soil and mud and through extreme heat and pressure, can change into coal in wetlands. *)
axiomatization where
  explanation_1: "∀x y z e. Peat x ∧ SoilAndMud y ∧ Wetlands z ∧ BuriedUnder e x y ∧ ExtremeHeatAndPressure e ⟶ Coal x"

theorem hypothesis:
  assumes asm: "Peat x ∧ SoilAndMud y ∧ Wetlands z ∧ BuriedUnder e x y ∧ ExtremeHeatAndPressure e"
  (* Hypothesis: Peat, buried under soil and mud and through extreme heat and pressure, can change into coal in wetlands. *)
  shows "Coal x"
proof -
  from asm have "Peat x ∧ SoilAndMud y ∧ Wetlands z ∧ BuriedUnder e x y ∧ ExtremeHeatAndPressure e" by simp
  then have "Coal x" using explanation_1 by blast
  then show ?thesis using asm `Coal x` by blast
qed

end
