theory question_5_9
imports Main

begin

typedecl entity
typedecl event

consts
  FootballPlayer :: "entity ⇒ bool"
  Entity :: "entity ⇒ bool"
  Plays :: "entity ⇒ entity ⇒ event ⇒ bool"
  Football :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Located :: "entity ⇒ entity ⇒ bool"
  LocatedOn :: "entity ⇒ entity ⇒ bool"
  Blue :: "entity ⇒ string ⇒ bool"
  Runs :: "entity ⇒ entity ⇒ bool"
  Attempts :: "entity ⇒ event ⇒ bool"
  Tackle :: "entity ⇒ entity ⇒ event ⇒ bool"
  Falls :: "entity ⇒ bool"
  White :: "entity ⇒ bool"

(* Explanation 1: A football player is an entity who plays football on a field. *)
axiomatization where
  explanation_1: "∀x. FootballPlayer x ⟶ (∃y z. Entity y ∧ Plays x y z ∧ On z f)"

(* Explanation 2: If an entity is located on something, then that entity is located on it. *)
axiomatization where
  explanation_2: "∀w x. Located w x ⟶ LocatedOn x w"

(* Explanation 3: A football player plays football on a field. *)
axiomatization where
  explanation_3: "∀x. FootballPlayer x ⟶ (∃y z. Football y ∧ Plays x y z ∧ On z f)"

theorem hypothesis:
  (* Premise: A football player in a blue 'Rams' jersey runs with a football on a field, as another player in a white jersey falls in an attempt to tackle him. *)
  assumes asm: "On x f  ∧ ∃z  FootballPlayer z ∧ White z ∧ Attempts z  Tackle z x  ∧ Falls z"
  (* Hypothesis: The football players are on a field. *)
  shows "∃x. FootballPlayer x ∧  On x f "
proof -
  from asm have "∃w. FootballPlayer w ∧ On w f" by auto
  then have "∃w. FootballPlayer w ∧ Located w f" using explanation_2 by blast
  then have "∃w. FootballPlayer w ∧ LocatedOn f w" using explanation_2 by blast
  from asm have "∃z. FootballPlayer z ∧ White z ∧ On z f" by auto
  then have "∃z. FootballPlayer z ∧ White z ∧ Located z f" using explanation_2 by blast
  then have "∃z. FootballPlayer z ∧ White z ∧ LocatedOn f z" using explanation_2 by blast
  then show ?thesis by blast
qed

end
