theory question_27_9
imports Main

begin

typedecl entity
typedecl event

consts
  Sidewalk :: "entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  Outdoors :: "entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Old :: "entity ⇒ bool"
  Sells :: "event ⇒ entity ⇒ entity ⇒ bool"
  HardwareParts :: "entity ⇒ bool"
  Dirty :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Location :: "event ⇒ entity ⇒ entity ⇒ bool"

(* Explanation 1: If an entity is located on a sidewalk, then that entity is outside. *)
axiomatization where
  explanation_1: "∀x. Sidewalk x ⟶ Outside x"

(* Explanation 2: The location of an entity on a sidewalk is outdoors. *)
axiomatization where
  explanation_2: "∀x. Sidewalk x ⟶ Outdoors x"

theorem hypothesis:
  (* Premise: A old man sells hardware parts on a dirty sidewalk. *)
  assumes asm: "Man x ∧ Old x ∧ Sells e x y ∧ HardwareParts y ∧ Sidewalk z ∧ Dirty z ∧ Agent Sells e x ∧ Patient Sells e y ∧ Location e x z"
  (* Hypothesis: The man is outside. *)
  shows "∃x. Man x ∧ Outside x"
proof -
  from asm have "Sidewalk z" by blast
  then have "Outside z" using explanation_1 by blast
  then have "Man x ∧ Outside x" using asm by blast
  then show ?thesis by blast
qed

end
