theory question_99_0

imports Main

begin
typedecl entity
typedecl event

consts
  Dog :: "entity ⇒ bool"
  Grass :: "entity ⇒ bool"
  Running :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A dog could also be running on grass. *)
axiomatization where
  explanation_1: "∃x y e. Dog x ∧ Grass y ∧ Running e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: A dog running on grass *)
  assumes asm: "Dog x ∧ Grass y ∧ Running e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: A dog is on the grass. *)
  shows "∃x y. Dog x ∧ Grass y ∧ On x y"
proof -
  from asm have "Dog x ∧ Grass y" by blast
  then show ?thesis using asm by blast
qed

end
