theory question_81_8

imports Main

begin

typedecl entity
typedecl event

consts
  ExternalMigration :: "entity ⇒ bool"
  BottleneckEffect :: "entity ⇒ bool"
  Trigger :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Triggered :: "event ⇒ bool"
  Occur :: "event ⇒ bool"
  Leads :: "event ⇒ bool"

(* Explanation 1: External migration can trigger the bottleneck effect. *)
axiomatization where
  explanation_1: "∀e x y. ExternalMigration x ∧ BottleneckEffect y ∧ Trigger e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: If the bottleneck effect is triggered, it leads to its occurrence. *)
axiomatization where
  explanation_2: "∀e1 e2 x y. BottleneckEffect x ∧ Triggered e1 ∧ Agent e1 x ⟶ Occur e2 ∧ Agent e2 x"

(* Explanation 3: If external migration triggers the bottleneck effect, it directly leads to the occurrence of the bottleneck effect. *)
axiomatization where
  explanation_3: "∀e1 e2 e3 x y. ExternalMigration x ∧ BottleneckEffect y ∧ Triggers e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ Leads e2 ∧ Agent e2 y ⟶ Occur e3 ∧ Agent e3 y"

theorem hypothesis:
  assumes asm: "BottleneckEffect x ∧ ExternalMigration y"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃e x y. BottleneckEffect x ∧ ExternalMigration y ∧ Occur e ∧ Agent e y ∧ Patient e x"
proof -
  from asm have "BottleneckEffect x ∧ ExternalMigration y" by simp
  then obtain e1 where e1: "Trigger e1 ∧ Agent e1 y ∧ Patient e1 x" using explanation_1 by blast
  then have "Leads e2 ∧ Agent e2 x" using explanation_3 e1 by blast
  then have "Occur e3 ∧ Agent e3 x" using explanation_3 e1 by blast
  have conclusion: "Trigger e1 ∧ Agent e1 y ∧ Patient e1 x" using e1 by simp
  show ?thesis using asm conclusion `Occur e3 ∧ Agent e3 x` by blast
qed

end
