theory question_39_8

imports Main

begin
typedecl entity
typedecl event

consts
  Boys :: "entity ⇒ bool"
  Basketball :: "event ⇒ bool"
  Uniform :: "entity ⇒ entity ⇒ bool"
  Playing :: "event ⇒ bool"
  Participant :: "event ⇒ entity ⇒ bool"
  ActivelyParticipating :: "event ⇒ bool"
  InGame :: "event ⇒ event ⇒ bool"
  GreenWhite :: "entity"
  BlueWhite :: "entity"
  Play :: "event ⇒ bool"

(* Explanation 1: Boys playing basketball in green and white uniforms are actively participating in the basketball game. *)
axiomatization where
  explanation_1: "∃x e1 e2. Boys x ∧ Basketball e1 ∧ Uniform x GreenWhite ∧ Playing e1 ∧ Participant e1 x ∧ ActivelyParticipating e2 ∧ InGame e2 e1"

theorem hypothesis:
  (* Premise: Two boys in green and white uniforms play basketball with two boys in blue and white uniforms. *)
  assumes asm: "Boys x ∧ Boys y ∧ Uniform x GreenWhite ∧ Uniform y BlueWhite ∧ Basketball e ∧ Play e ∧ Participant e x ∧ Participant e y"
  (* Hypothesis: Boys are playing basketball. *)
  shows "∃x e. Boys x ∧ Basketball e ∧ Playing e ∧ Participant e x"
proof -
  from asm have "Boys x ∧ Boys y ∧ Basketball e ∧ Play e ∧ Participant e x" by blast
  then have "Boys x ∧ Basketball e ∧ Playing e ∧ Participant e x" using explanation_1 by blast
  then show ?thesis using `Boys x` by blast
qed

end
