
## Data Augmentation for Entity Resolution

There are two main data augmentation (DA) groups:
- Conventional DA are contained in `conventional_aug.py`
- GAN-based DA is implemented in `GAN_model.py` and `pre_processing_GAN.py` scripts. See documentation below for usage

### conventional_aug.py

```
python conventional_aug.py --input --aug --output [--src-lex] [--src-lang-lex] [--chr-specific] [--src-nmt] [--tar-nmt] [--src] [--inter] [--tar]

  --input INPUT         Original text data. Only receive json file. (default: None) **Required**
  
  --aug AUG             Choose augmentation methods: lexical / spelling /
                        character / translation / back-translation. (default:
                        None) **Required**
                        
  --output OUTPUT       Name of output file. Only generate json file. (default: None) **Required**
  
  --src-lex SRC_LEX     Source for lexical. (default: wordnet)
  
  --src-lang-lex SRC_LANG_LEX Source language for lexical. (default: fra)
                        
  --chr-specific CHR_SPECIFIC
                        Select insert, substitute, swap or delete method in
                        character-level (default: None)
                        
  --src-nmt SRC_NMT     Source NMT location (default: None)
  
  --tar-nmt TAR_NMT     Target NMT location (default: None)
  
  --src SRC             Source language for translation / back-translation (default: None)
  
  --inter INTER         Intermediate language for translation / back-translation (default: en)
  
  --tar TAR             Target language for translation (default: fr)
```

This contains the five augmentation methods: **lexical / spelling / character / translation / back-translation**. It receives the input text file (json) and generate the output text file (json). You can use the sample_example.json in the bucket for sample run.

Input is a dictionary looks like : {Original text 1: [ ], Original text 2: [ ], ...}. Thus, original text will be keys in dictionary and synthetic data will be values in each of original text.

Example of back-translation: {'chambre enfant': ["chambre d'enfants"], 'lampe': ['feu'], 'salon': ['salon'], 'cuisine': ['cuisine'], 'lampe de chevet': ['Lampe de chevet'], 'Canapé': ['canapé']}


(1) Lexical: It is basically finding a synonym from WordNet.

**To run the code:** python conventional_aug.py --input sample_example.json --aug lexical --output syn_data.json --src-lex wordnet --src-lang-lex fra

(2) Spelling: It is changing some characters for synthesizing.

**To run the code:** python conventional_aug.py --input sample_example.json --aug spelling --output syn_data.json

(3) Character: Four different character augmentations can be considered: insert, substitute, swap or delete. 

**To run the code:** python conventional_aug.py --input sample_example.json --aug character --output syn_data.json --chr-specific insert

(4) Translation: Now, it is based on De -> En -> Fr. Please use the sample_example_de.json as input for sample run.

**To run the code:** python conventional_aug.py --input sample_example_de.json --aug translation --output syn_data.json --src-nmt /home/ec2-user/easynmt/opus-de-en/ --tar-nmt /home/ec2-user/easynmt/opus-en-fr/ --src de --inter en --tar fr

(5) Back-Translation: Now, it is based on Fr -> En -> Fr.

**To run the code:** python conventional_aug.py --input sample_example.json --aug back-translation --output syn_data.json --src-nmt /home/ec2-user/easynmt/opus-fr-en/ --tar-nmt /home/ec2-user/easynmt/opus-en-fr/ --src fr --inter en


***Prerequisites*** 

The conda environment is based on tensorflow2_p36 environment from Amazon ML AMI

fasttext-0.9.2 / huggingface-hub-0.1.2 / Keras-2.4.3 / matplotlib-3.1.3 / nltk-3.4.5 / numpy-1.19.5 / re-2.2.1 / sentencepiece-0.1.96 / tensorflow-2.4.1 / tokenizers-0.10.3 / torch-1.10.0 / transformers-4.12.5


At below, I add the specific requirements for each augmentation.

Word-level: nlpaug-1.1.7/ nltk: averaged_perceptron_tagger / nltk: wordnet / nltk: omw

*https://www.nltk.org/nltk_data/* 

Character-level: nlpaug-1.1.7 

Translation: EasyNMT-2.0.1.tar / nltk: punkt / pre-trained mt from *https://huggingface.co/Helsinki-NLP* 

*https://github.com/UKPLab/EasyNMT* 

Back-Translation: Same as Translation 


### pre_processing_GAN.py 

```
python pre_processing_GAN.py --input --gan --output --hidden --model-loc [--ft-lang] [--dimension] [--hidden]

  --input INPUT         Original text data. Only receive json file. (default:
                        None) **Required**
                        
  --gan GAN             Choose GAN methods: fasttext / bert / bart. (default:
                        None)  **Required**
                        
  --output OUTPUT       Name of output file. Only generate npz file. (default:
                        None) **Required**
                        
  --model-loc MODEL_LOC
                        Pre-trained model location. (default: None) **Required**
                        
  --ft-lang FT_LANG     Language used in FastText (default: french)
  
  --dimension DIMENSION
                        Number of tokens considered in BART-GAN (default: 6)

  --hidden HIDDEN       Hidden unit for BART-GAN. (default: 768)
```

This is for changing the text into embedding before applying in the GAN model. Three methods are considered: **FastText-GAN / BERT-GAN / BART-GAN.** It receives the text file (json) and generate the embedding file (npz) with its original text. You can use the sample_example_GAN.json in the bucket for sample run. 

Input is a dictionary looks like : {Original text 1: [ ], Original text 2: [ ], ...}. Output has two arrays where one is for saving the original text and the other is for saving the embedding of that text.

(1) FastText-GAN: In this model, synthetic data is generated for each single word and thus, normalization task is applied. The process is as follows: Remove stop words -> Remove numbers -> Remove punctuation -> Split data according to whitespace. Then, pre-trained FastText is used to generate the embedding for each single word where the default hidden unit is 300. 

**To run the code:** python pre_processing_GAN.py --input sample_example_GAN.json --gan fasttext --output embed_fasttext.npz --model-loc ft_model/cc.fr.300.bin 

(2) BERT-GAN: In this model, synthetic data is generated for each sentence. To get the embedding of each sentence, we average the second to last hidden layer of each token of sentence, and also average the tokens in a sentence. Finally, this gives 768 hidden units for each sentence. 

**To run the code:** python pre_processing_GAN.py --input sample_example_GAN.json --gan bert --output embed_bert.npz --model-loc /home/ec2-user/multilingual_L-12_H-768_A-12/

(3) BART-GAN: In this model, synthetic data is generated for each sentence. Here, each data consists of 768 x # of considered tokens since each token has 768 hidden units from encoder of BART and occupies each dimension. 

**To run the code:** python pre_processing_GAN.py --input sample_example_GAN.json --gan bart --output embed_bart.npz --model-loc /home/ec2-user/barthez --dimension 6


***Prerequisites*** 

The conda environment is based on tensorflow2_latest_p37 from Amazon ML AMI

huggingface-hub-0.1.2 / Keras-Preprocessing-1.1.2 / matplotlib-3.1.3 / numpy-1.18.1 / pandas-1.0.1 / re-2.2.1 / sentencepiece-0.1.82 / tensorflow-gpu-2.3.0 / tokenizers-0.10.3 / torch-1.10.0 / transformers-4.12.5


At below, I add the specific requirements for each augmentation.

FastText-GAN: fasttext-0.9.2 / stop-words-2018.7.23.tar/ pretrained-model from *https://fasttext.cc/docs/en/crawl-vectors.html* 

BERT-GAN: pretrained-model from *https://github.com/google-research/bert/blob/master/multilingual.md* 

BART-GAN: pretrained-model from *https://github.com/moussaKam/BARThez* 



### GAN_model.py

```
python GAN_model.py --input --gan --output --model-loc [--dict-bert] [--batch-size] [--epoch] [--learning-rate] [--ft-score] [--bart-score-low] [--bart-score-high] [--dimension] [--loss-fig]

  --input INPUT         Original embedding data. Only receive npz file.
                        (default: None) **Required**
                        
  --gan GAN             Choose GAN methods: fasttext / bert / bart. (default:
                        None) **Required**
                        
  --output OUTPUT       Name of output file. Only generate json file.
                        (default: None) **Required**
                        
  --model-loc MODEL_LOC
                        Pre-trained model location (default: None) **Required**
                        
  --dict-bert DICT_BERT
                        Dictionary for BERT from translated traffic (default:
                        None)
                        
  --batch-size BATCH_SIZE
                        Batch size used in GAN (default: 10)
                        
  --epoch EPOCH         Number of epochs used in GAN (default: 30)
  
  --learning-rate LEARNING_RATE
                        Learning rate used in GAN (default: 0.0001)
                        
  --ft-score FT_SCORE   Threshold for measuring similarity in FastText-GAN
                        (default: 1.3)
                        
  --bart-score-low BART_SCORE_LOW
                        Low threshold for measuring similarity in BART-GAN
                        (default: 0.3)
                        
  --bart-score-high BART_SCORE_HIGH
                        High threshold for measuring similarity in BART-GAN
                        (default: 0.7)
                        
  --dimension DIMENSION
                        Number of tokens considered in BART-GAN (default: 6)
                        
  --loss-fig LOSS_FIG   Name of loss figure (default: GAN_Loss.png)
```

This is for training the GAN model and generate the synthetic data at last. Three methods are considered: **FastText-GAN / BERT-GAN / BART-GAN.** It receives the embedding file (npz) and generates the synthetic text file (json) for each original text. Output file has dictionary type (i.e. original text: [synthetic text1, synthetic text2 …]). **You need to run pre_processing_GAN.py first since GAN needs the embedding of original texts (i.e. output file of it).**

Generator in FastText is slightly different from BERT and BART since the size of hidden unit is different (300 vs 768). Discriminator is same for all approaches. Training checkpoints are saved and thus, you can call the model later. After finishing the GAN training, the loss function is saved and different methods are used to generate synthetic data in each GAN method. For reference, the sample example is not enough for getting proper synthetic data (in this case, some original text does not have synthetic data) but you can see how the code works. The time complexity of code can be decreased if we split the GAN training and generation of synthetic data since the latter one can be done parallel.

Input has two arrays where one is for saving the original text and the other is for saving the embedding of that text. Output is a dictionary looks like : {Original text 1: [Synthetic text 1, Synthetic text 2], ...}.

(1) FastText-GAN: Embedding of original text with Gaussian noise is applied in Generator to produce the synthetic embedding. Then, cosine similarity between synthetic embedding and embeddings in dictionary of pre-trained FastText is applied to find the most similar words. Finally, additional similarity matching between selected words from dictionary and original word is done for finding most proper synthetic word. 

**To run the code:** python GAN_model.py --input embed_fasttext.npz --gan fasttext --model-loc ft_model/cc.fr.300.bin --output syn_gan_fasttext.json

(2) BERT-GAN: Embedding of original text with Gaussian noise is applied in Generator to produce the synthetic embedding. Then, cosine similarity between synthetic embedding and embeddings from dictionary is applied to find the most similar sentences. The dictionary comes from translation of other language (the example comes from German).  

**To run the code:** python GAN_model.py --input embed_bert.npz --gan bert --model-loc /home/ec2-user/multilingual_L-12_H-768_A-12/ --output syn_gan_bert.json --dict-bert dict_embedding_bert_gan.npz

(3) BART-GAN: Embedding of original text with Gaussian noise is applied in Generator to produce the synthetic embedding. Then, original and synthetic embeddings are averaged. In each dimension, cosine similarity between synthetic embedding and embeddings from dictionary is applied. Finally, decoder in BART is applied to make synthetic data.

**To run the code:** python GAN_model.py --input embed_bart.npz --gan bart --model-loc /home/ec2-user/barthez/ --output syn_gan_bart.json


***Prerequisites are same as pre_processing_GAN.py***

## Security

See [CONTRIBUTING](CONTRIBUTING.md#security-issue-notifications) for more information.

## License

This library is licensed under the CC-BY-NC-4.0 License.
