import os
import copy
import nltk
from nltk.corpus import stopwords

PATH_BASE = os.getcwd()
PATH_WORDLIST = os.path.join(PATH_BASE, "wordlists")
PATH_LEX = os.path.join(PATH_BASE, "lex_stats_DUTA")

FILE_VALIDS = os.path.join(PATH_WORDLIST, "english_duta_valid.txt")
FILE_TEMPLIST = os.path.join(PATH_WORDLIST, "temp_processed.txt")
FILE_DEST = os.path.join(PATH_LEX, "most_frequent_words.txt")
FILE_DEST_STOP = os.path.join(PATH_LEX, "most_frequent_words_wostop.txt")

with open(FILE_VALIDS, 'r') as f:
    valid_words = f.readlines()
    valid_words = [word.strip() for word in valid_words]

occurrences = {word : 0 for word in valid_words}

with open(FILE_TEMPLIST, 'r') as f:
    all_words = f.readlines()
    all_words = [word.strip() for word in all_words]

for word in all_words:
    try:
        occurrences[word] += 1
    except KeyError:
        pass

occurrences_sorted = dict(sorted(occurrences.items(), key=lambda item: item[1], reverse=True))

occurrences_no_stopwords = copy.deepcopy(occurrences_sorted)
stopwords = stopwords.words('english')

for stopword in stopwords:
    occurrences_no_stopwords.pop(stopword, None)

fdest = open(FILE_DEST, 'w')
fdest.write('Most common words in DUTA-10K\n')
fdest.write('Word : Frequency\n\n')

for word, freq in occurrences_sorted.items():
    fdest.write(f'{word:<20} : {freq}\n')

fdest.close()

fdest = open(FILE_DEST_STOP, 'w')
fdest.write('Most common words in DUTA-10K excluding stopwords\n')
fdest.write('Word : Frequency\n\n')

for word, freq in occurrences_no_stopwords.items():
    fdest.write(f'{word:<20} : {freq}\n')

fdest.close()