#!/usr/bin/env bash
echo "----- entropy coeff------------------"
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VQA_exp_size_truncation_smallvocab_maxlen10/temperature_pth_32_64/hparams" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.02 -lr 0.0001 -word_emb_size 32 -hidden_size 64 -num_episodes_train 20000 -debug "0,2000" -lm_path "output/vqa_lm_model_smallvocab/model.pt" -reward "bleu_sf2" -num_episodes_test 100 -mask_answers 1 -truncate_mode "proba_thr" -grad_clip 1 -fusion "average" -condition_answer "after_fusion" -init_text "Here are a few examples:" -custom_init 100 -device_id 3 -min_data 1 -temperature 2 -temp_step 1000 -temp_factor 0.75 -temp_min 0.7 -p_th 0.002 -s_min 1 -s_max 200 -entropy_coeff 0.01
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VQA_exp_size_truncation_smallvocab_maxlen10/temperature_pth_32_64/hparams" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.02 -lr 0.0001 -word_emb_size 32 -hidden_size 64 -num_episodes_train 20000 -debug "0,2000" -lm_path "output/vqa_lm_model_smallvocab/model.pt" -reward "bleu_sf2" -num_episodes_test 100 -mask_answers 1 -truncate_mode "proba_thr" -grad_clip 1 -fusion "average" -condition_answer "after_fusion" -init_text "Here are a few examples:" -custom_init 100 -device_id 3 -min_data 1 -temperature 2 -temp_step 1000 -temp_factor 0.75 -temp_min 0.7 -p_th 0.002 -s_min 1 -s_max 200 -entropy_coeff 0.05
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VQA_exp_size_truncation_smallvocab_maxlen10/temperature_pth_32_64/hparams" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.02 -lr 0.0001 -word_emb_size 32 -hidden_size 64 -num_episodes_train 20000 -debug "0,2000" -lm_path "output/vqa_lm_model_smallvocab/model.pt" -reward "bleu_sf2" -num_episodes_test 100 -mask_answers 1 -truncate_mode "proba_thr" -grad_clip 1 -fusion "average" -condition_answer "after_fusion" -init_text "Here are a few examples:" -custom_init 100 -device_id 3 -min_data 1 -temperature 2 -temp_step 1000 -temp_factor 0.75 -temp_min 0.7 -p_th 0.002 -s_min 1 -s_max 200 -entropy_coeff 0.005
echo "----- optimizer------------------"
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VQA_exp_size_truncation_smallvocab_maxlen10/temperature_pth_32_64/hparams" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.02 -lr 0.0001 -optimizer "sgd" -word_emb_size 32 -hidden_size 64 -num_episodes_train 20000 -debug "0,2000" -lm_path "output/vqa_lm_model_smallvocab/model.pt" -reward "bleu_sf2" -num_episodes_test 100 -mask_answers 1 -truncate_mode "proba_thr" -grad_clip 1 -fusion "average" -condition_answer "after_fusion" -init_text "Here are a few examples:" -custom_init 100 -device_id 3 -min_data 1 -temperature 2 -temp_step 1000 -temp_factor 0.75 -temp_min 0.7 -p_th 0.002 -s_min 1 -s_max 200 -entropy_coeff 0.01
echo "------ epsilon loss PPO ----------"
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VQA_exp_size_truncation_smallvocab_maxlen10/temperature_pth_32_64/hparams" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.01 -lr 0.0001 -word_emb_size 32 -hidden_size 64 -num_episodes_train 20000 -debug "0,2000" -lm_path "output/vqa_lm_model_smallvocab/model.pt" -reward "bleu_sf2" -num_episodes_test 100 -mask_answers 1 -truncate_mode "proba_thr" -grad_clip 1 -fusion "average" -condition_answer "after_fusion" -init_text "Here are a few examples:" -custom_init 100 -device_id 3 -min_data 1 -temperature 2 -temp_step 1000 -temp_factor 0.75 -temp_min 0.7 -p_th 0.002 -s_min 1 -s_max 200 -entropy_coeff 0.01
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VQA_exp_size_truncation_smallvocab_maxlen10/temperature_pth_32_64/hparams" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.1 -lr 0.0001 -word_emb_size 32 -hidden_size 64 -num_episodes_train 20000 -debug "0,2000" -lm_path "output/vqa_lm_model_smallvocab/model.pt" -reward "bleu_sf2" -num_episodes_test 100 -mask_answers 1 -truncate_mode "proba_thr" -grad_clip 1 -fusion "average" -condition_answer "after_fusion" -init_text "Here are a few examples:" -custom_init 100 -device_id 3 -min_data 1 -temperature 2 -temp_step 1000 -temp_factor 0.75 -temp_min 0.7 -p_th 0.002 -s_min 1 -s_max 200 -entropy_coeff 0.01
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VQA_exp_size_truncation_smallvocab_maxlen10/temperature_pth_32_64/hparams" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.5 -lr 0.0001 -word_emb_size 32 -hidden_size 64 -num_episodes_train 20000 -debug "0,2000" -lm_path "output/vqa_lm_model_smallvocab/model.pt" -reward "bleu_sf2" -num_episodes_test 100 -mask_answers 1 -truncate_mode "proba_thr" -grad_clip 1 -fusion "average" -condition_answer "after_fusion" -init_text "Here are a few examples:" -custom_init 100 -device_id 3 -min_data 1 -temperature 2 -temp_step 1000 -temp_factor 0.75 -temp_min 0.7 -p_th 0.002 -s_min 1 -s_max 200 -entropy_coeff 0.01
echo "------- grad clipping ------------------"
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VQA_exp_size_truncation_smallvocab_maxlen10/temperature_pth_32_64/hparams" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.02 -lr 0.0001 -word_emb_size 32 -hidden_size 64 -num_episodes_train 20000 -debug "0,2000" -lm_path "output/vqa_lm_model_smallvocab/model.pt" -reward "bleu_sf2" -num_episodes_test 100 -mask_answers 1 -truncate_mode "proba_thr" -fusion "average" -condition_answer "after_fusion" -init_text "Here are a few examples:" -custom_init 100 -device_id 3 -min_data 1 -temperature 2 -temp_step 1000 -temp_factor 0.75 -temp_min 0.7 -p_th 0.002 -s_min 1 -s_max 200 -entropy_coeff 0.01
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VQA_exp_size_truncation_smallvocab_maxlen10/temperature_pth_32_64/hparams" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.02 -lr 0.0001 -word_emb_size 32 -hidden_size 64 -num_episodes_train 20000 -debug "0,2000" -lm_path "output/vqa_lm_model_smallvocab/model.pt" -reward "bleu_sf2" -num_episodes_test 100 -mask_answers 1 -truncate_mode "proba_thr" -fusion "average" -condition_answer "after_fusion" -init_text "Here are a few examples:" -custom_init 100 -device_id 3 -min_data 1 -temperature 2 -temp_step 1000 -temp_factor 0.75 -temp_min 0.7 -p_th 0.002 -s_min 1 -s_max 200 -entropy_coeff 0.01 -grad_clip 5
python src/scripts/run.py -env "vqa" -max_len 10 -data_path "data/vqa-v2" -out_path "output/RL/VQA_exp_size_truncation_smallvocab_maxlen10/temperature_pth_32_64/hparams" -model "lstm" -update_every 128 -agent "PPO" -K_epochs 20 -eps_clip 0.02 -lr 0.0001 -word_emb_size 32 -hidden_size 64 -num_episodes_train 20000 -debug "0,2000" -lm_path "output/vqa_lm_model_smallvocab/model.pt" -reward "bleu_sf2" -num_episodes_test 100 -mask_answers 1 -truncate_mode "proba_thr" -fusion "average" -condition_answer "after_fusion" -init_text "Here are a few examples:" -custom_init 100 -device_id 3 -min_data 1 -temperature 2 -temp_step 1000 -temp_factor 0.75 -temp_min 0.7 -p_th 0.002 -s_min 1 -s_max 200 -entropy_coeff 0.01 -grad_clip 10
