task="story_generation"
lrs=(5e-5)
batch=(10)
seeds=(5)

device="0"
event_num=5
model="facebook/bart-base"
suffix="gen_with_no_rel_story_input"
root="../output/"

filenames=("_storyline_pred.json")

for l in "${lrs[@]}"
do
  for s in "${batch[@]}"
  do
    for seed in "${seeds[@]}"
    do
	    for filename in "${filenames[@]}"
	    do
        python eval_story_generation.py \
        --data_dir "../data/" \
        --model ${model} \
        --task_name  ${task} \
        --file_suffix ${filename}\
        --device_num ${device} \
        --eval_batch_size 10 \
        --num_train_epochs 10 \
        --learning_rate ${l} \
        --input_event_num ${event_num} \
        --seed ${seed} \
        --model_dir "${root}/${task}/${model}_batch_${s}_lr_${l}_seed_${seed}_event_${event_num}_${suffix}/"
        done
      done
    done
done
