import json
import jsonlines
from collections import defaultdict

results = []
with open('snap/valid/submit_test.json', 'r') as f:
    results = json.load(f)
f.close()

processed_results = []
for i, result in enumerate(results):
    p_result = dict()
    p_result['instruction_id'] = result['instr_id']
    p_result['path'] = [traj[0] for traj in result['trajectory']]
    processed_results.append(p_result)

with jsonlines.open('snap/valid/submit_test_processed_clip.jsonl', mode='w') as writer:
    writer.write_all(processed_results)



# results = []
# with open('snap/valid_clip/submit_test.json', 'r') as f:
#     results = json.load(f)
# f.close()
#
# for i, result in enumerate(results):
#     del results[i]['path_id']
#
# json.dump(
#                 results,
#                 open('snap/valid_clip/submit_test_processed_clip.json', 'w'),
#                 sort_keys=True, indent=4, separators=(',', ': ')
#             )
# processed_results = []
# for i, result in enumerate(results):
#     p_result = dict()
#     p_result['instruction_id'] = result['instr_id']
#     p_result['path'] = [traj[0] for traj in result['trajectory']]
#     processed_results.append(p_result)
#
# with jsonlines.open('snap/valid/submit_test_processed.jsonl', mode='w') as writer:
#     writer.write_all(processed_results)