from libc.stdint cimport uint32_t
from libcpp.utility cimport pair
from libcpp.vector cimport vector
from libcpp.string cimport string
from .containers cimport (SmallChartItem, FatChartItem, Prob, Label, ItemNo,
		Grammar, ProbRule, Chart, Edge, RankedEdge, RankedEdgeAgenda,
		CFGtoSmallChartItem, CFGtoFatChartItem, sparse_hash_map,
		RankedEdgeSet, Priority)
from .pcfg cimport CFGChart, DenseCFGChart, SparseCFGChart
from .plcfrs cimport LCFRSChart, SmallLCFRSChart, FatLCFRSChart

ctypedef sparse_hash_map[ItemNo, RankedEdgeAgenda[Priority]] agendas_type

cdef string getderiv(ItemNo v, RankedEdge ej, Chart chart)
cdef collectitems(ItemNo v, RankedEdge& ej, Chart chart, itemset)
