""" Example Hierarchical Matrix Table
question:
    which city has the most single persons?

table:
    |               |  male               |  female             |
    |               |  married  |  single |  married  |  single |
    |area_a         |           |         |           |         |
    |   west_city_a |  101      |  201    |  98       |  51     |
    |   east_city_a |  102      |  202    |  97       |  49     |
    |area_b         |           |         |           |         |
    |   mid_city_b  |  104      |  204    |  95       |  100    |

answer:
    1
"""

DUMMY_EXAMPLE_DICT = {
  'id': 'dummy_0',
  'tokens': ['here', 'is', 'a', 'dummy', "question"],
  'entities': [

  ],
  'features': [[0], [0], [0], [0], [0]],
  'answer': ['dummy_answer'],
  'prop_features': {
    'dummy_prop': [0]
  }
}


EXAMPLE_DICT = {
    "id": "nu_0",
    "tokens": ["which", "city", "has", "the", "most", "single", "persons", "?"],
    "entities": [
        {"token_start": 5, "token_end": 6, "type": "string_list", "value": ["single"]},
    ],
    "features": [[0], [0], [0], [0], [0], [1], [0], [0]],
    "answer": ["mid_city_b"],
    "prop_features": {
        "male": [0],
        "female": [0],
        "married": [0],
        "single": [1],
        "area_a": [0],
        "area_b": [0],
        "west_city_a": [0],
        "east_city_a": [0],
        "mid_city_b": [0]
    }
}

KG = {
    "top_root": {
        "name": "<TOP>",
        "children_dict": [
            {
                "name": "male",
                "children_dict": [
                    {"name": "married", "start_end_idx": 0},
                    {"name": "single", "start_end_idx": 1}
                ]
            },
            {
                "name": "female",
                "children_dict": [
                    {"name": "married", "start_end_idx": 2},
                    {"name": "single", "start_end_idx": 3}
                ]
            }
        ]
    },
    "left_root": {
        "name": "<LEFT>",
        "children_dict": [
            {
                "name": "area_a",
                "children_dict": [
                    {"name": "west_city_a", "start_end_idx": 0},
                    {"name": "east_city_a", "start_end_idx": 1}
                ]
            },
            {
                "name": "area_b",
                "children_dict": [
                    {"name": "mid_city_b", "start_end_idx": 2},
                ]
            }
        ]
    },
    "data": [
        [{"value": 101}, {"value": 201}, {"value": 98}, {"value": 51}],
        [{"value": 102}, {"value": 202}, {"value": 97}, {"value": 49}],
        [{"value": 104}, {"value": 204}, {"value": 95}, {"value": 100}]
    ]
}


EXAMPLE_DICT_W_AGGR_LINE = {
    "id": "nu_0",
    "tokens": ["which", "city", "has", "the", "most", "single", "persons", "?"],
    "entities": [
        {"token_start": 5, "token_end": 6, "type": "string_list", "value": ["single"]},
    ],
    "features": [[0], [0], [0], [0], [0], [1], [0], [0]],
    "answer": ["mid_city_b"],
    "prop_features": {
        "male": [0],
        "female": [0],
        "married": [0],
        "single": [1],
        "area_a": [0],
        "area_b": [0],
        "west_city_a": [0],
        "east_city_a": [0],
        "mid_city_b": [0]
    }
}

KG_W_AGGR_LINE = {
    "top_root": {
        "name": "<TOP>",
        "value": "<TOP>",
        "type": "string",
        "line_idx": None,
        "children_dict": [
            {
                "name": "male",
                "value": "male",
                "type": "string",
                "line_idx": None,
                "children_dict": [
                    {
                        "name": "married",
                        "value": "married",
                        "type": "string",
                        "line_idx": 0,
                        "index_name": "marriage type"
                    },
                    {
                        "name": "single",
                        "value": "single",
                        "type": "string",
                        "line_idx": 1,
                        "index_name": "marriage type"
                    },
                ],
                "index_name": "sex"
            },
            {
                "name": "female",
                "value": "female",
                "type": "string",
                "line_idx": None,
                "children_dict": [
                    {
                        "name": "married",
                        "value": "married",
                        "type": "string",
                        "line_idx": 2,
                        "index_name": "marriage type"
                    },
                    {
                        "name": "single",
                        "value": "single",
                        "type": "string",
                        "line_idx": 3,
                        "index_name": "marriage type"
                    },
                ],
                "index_name": "sex"
            },
        ],
        "index_name": None,
    },
    "left_root": {
        "name": "<LEFT>",
        "value": "<LEFT>",
        "type": "string",
        "line_idx": None,
        "children_dict": [
            {
                "name": "area_a",
                "value": "area_a",
                "type": "string",
                "line_idx": 0,
                "children_dict": [
                    {
                        "name": "west_city_a",
                        "value": "west_city_a",
                        "type": "string",
                        "line_idx": 1,
                        "index_name": "city"
                    },
                    {
                        "name": "east_city_a",
                        "value": "east_city_a",
                        "type": "string",
                        "line_idx": 2,
                        "index_name": "city"
                    }
                ],
                "index_name": "area"
            },
            {
                "name": "area_b",
                "value": "area_b",
                "type": "string",
                "line_idx": 3,
                "children_dict": [
                    {
                        "name": "mid_city_b",
                        "value": "mid_city_a",
                        "type": "string",
                        "line_idx": 4,
                        "index_name": "city"
                    },
                ]
            }
        ],
        "index_name": None
    },
    "data": [
        [{"value": 203}, {"value": 403}, {"value": 195}, {"value": 100}],
        [{"value": 101}, {"value": ''}, {"value": 98}, {"value": 51}],
        [{"value": 102}, {"value": 202}, {"value": 97}, {"value": 49}],
        [{"value": 2}, {"value": 3}, {"value": 4}, {"value": 5}],
        [{"value": 104}, {"value": 204}, {"value": 95}, {"value": 100}]
    ]
}



EXAMPLE_DICT_JULY_4 = {
  "id": "nu_0",
  "tokens": ["which", "new zealand", "airport", "has", "the", "most", "arrivals", "?"],
  "entities": [
    {"token_start": 1, "token_end": 3, "type": "string_list", "value": ["new zealand airport"]},
  ],
  "features": [[0], [1], [1], [0], [0], [0], [0], [0]],
  "answer": ["Auckland"],
  "prop_features": {
      'arrivals': [0],
      'new zealand airports': [1]
  }
}

KG_JULY_4 = {
  "top_root": {
    "name": "<TOP>",
    "value": "<TOP>",
    "type": "string",
    "children_dict": [
      {
        "name": "arrivals",
        "value": "arrivals",
        "type": "string",
        "start_end_idx": 0,
        "index_name": "arrivals or departures"
      },
      {
        "name": "departures",
        "value": "departures",
        "type": "string",
        "start_end_idx": 1,
        "index_name": "arrivals or departures"
      }
    ],
    "index_name": "none"
  },
  "left_root": {
    "name": "<LEFT>",
    "value": "<LEFT>",
    "type": "string",
    "children_dict": [
      {
        "name": "auckland",
        "value": "auckland",
        "type": "string",
        "children_dict": [
          {
            "name": "sydney",
            "value": "sydney",
            "type": "string",
            "start_end_idx": 0,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "brisbane",
            "value": "brisbane",
            "type": "string",
            "start_end_idx": 1,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "melbourne",
            "value": "melbourne",
            "type": "string",
            "start_end_idx": 2,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "los angeles",
            "value": "los angeles",
            "type": "string",
            "start_end_idx": 3,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "singapore",
            "value": "singapore",
            "type": "string",
            "start_end_idx": 4,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "hong kong",
            "value": "hong kong",
            "type": "string",
            "start_end_idx": 5,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "nadi",
            "value": "nadi",
            "type": "string",
            "start_end_idx": 6,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "seoul",
            "value": "seoul",
            "type": "string",
            "start_end_idx": 7,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "bangkok",
            "value": "bangkok",
            "type": "string",
            "start_end_idx": 8,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "kuala lumpur",
            "value": "kuala lumpur",
            "type": "string",
            "start_end_idx": 9,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "rarotonga",
            "value": "rarotonga",
            "type": "string",
            "start_end_idx": 10,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "tokyo",
            "value": "tokyo",
            "type": "string",
            "start_end_idx": 11,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "san francisco",
            "value": "san francisco",
            "type": "string",
            "start_end_idx": 12,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "apia",
            "value": "apia",
            "type": "string",
            "start_end_idx": 13,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "perth",
            "value": "perth",
            "type": "string",
            "start_end_idx": 14,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "coolangatta",
            "value": "coolangatta",
            "type": "string",
            "start_end_idx": 15,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "london",
            "value": "london",
            "type": "string",
            "start_end_idx": 16,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "osaka",
            "value": "osaka",
            "type": "string",
            "start_end_idx": 17,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "tonga",
            "value": "tonga",
            "type": "string",
            "start_end_idx": 18,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "papeete",
            "value": "papeete",
            "type": "string",
            "start_end_idx": 19,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "dubai",
            "value": "dubai",
            "type": "string",
            "start_end_idx": 20,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "taipei",
            "value": "taipei",
            "type": "string",
            "start_end_idx": 21,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "adelaide",
            "value": "adelaide",
            "type": "string",
            "start_end_idx": 22,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "cairns",
            "value": "cairns",
            "type": "string",
            "start_end_idx": 23,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "honolulu",
            "value": "honolulu",
            "type": "string",
            "start_end_idx": 24,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "noumea",
            "value": "noumea",
            "type": "string",
            "start_end_idx": 25,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "santiago",
            "value": "santiago",
            "type": "string",
            "start_end_idx": 26,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "buenos aires",
            "value": "buenos aires",
            "type": "string",
            "start_end_idx": 27,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "port vila",
            "value": "port vila",
            "type": "string",
            "start_end_idx": 28,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "suva",
            "value": "suva",
            "type": "string",
            "start_end_idx": 29,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "norfolk island",
            "value": "norfolk island",
            "type": "string",
            "start_end_idx": 30,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "nagoya",
            "value": "nagoya",
            "type": "string",
            "start_end_idx": 31,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "denpasar",
            "value": "denpasar",
            "type": "string",
            "start_end_idx": 32,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "shanghai",
            "value": "shanghai",
            "type": "string",
            "start_end_idx": 33,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "fukuoka",
            "value": "fukuoka",
            "type": "string",
            "start_end_idx": 34,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "brunei",
            "value": "brunei",
            "type": "string",
            "start_end_idx": 35,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "niue",
            "value": "niue",
            "type": "string",
            "start_end_idx": 36,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "other(3)",
            "value": "other(3)",
            "type": "string",
            "start_end_idx": 37,
            "index_name": "overseas airport(2)"
          }
        ],
        "index_name": "new zealand airport(1)"
      },
      {
        "name": "hamilton",
        "value": "hamilton",
        "type": "string",
        "children_dict": [
          {
            "name": "brisbane",
            "value": "brisbane",
            "type": "string",
            "start_end_idx": 38,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "sydney",
            "value": "sydney",
            "type": "string",
            "start_end_idx": 39,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "coolangatta",
            "value": "coolangatta",
            "type": "string",
            "start_end_idx": 40,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "melbourne",
            "value": "melbourne",
            "type": "string",
            "start_end_idx": 41,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "nadi",
            "value": "nadi",
            "type": "string",
            "start_end_idx": 42,
            "index_name": "overseas airport(2)"
          },
          {
            "name": "other(3)",
            "value": "other(3)",
            "type": "string",
            "start_end_idx": 43,
            "index_name": "overseas airport(2)"
          }
        ],
        "index_name": "new zealand airport(1)"
      }
    ],
    "index_name": "none"
  },
  "data": [
    [
      {
        "value": 609.406,
        "value_name": None
      },
      {
        "value": 605.701,
        "value_name": None
      }
    ],
    [
      {
        "value": 370.731,
        "value_name": None
      },
      {
        "value": 345.311,
        "value_name": None
      }
    ],
    [
      {
        "value": 319.469,
        "value_name": None
      },
      {
        "value": 308.29,
        "value_name": None
      }
    ],
    [
      {
        "value": 230.976,
        "value_name": None
      },
      {
        "value": 226.821,
        "value_name": None
      }
    ],
    [
      {
        "value": 218.412,
        "value_name": None
      },
      {
        "value": 216.773,
        "value_name": None
      }
    ],
    [
      {
        "value": 181.087,
        "value_name": None
      },
      {
        "value": 175.707,
        "value_name": None
      }
    ],
    [
      {
        "value": 145.216,
        "value_name": None
      },
      {
        "value": 150.342,
        "value_name": None
      }
    ],
    [
      {
        "value": 88.258,
        "value_name": None
      },
      {
        "value": 86.922,
        "value_name": None
      }
    ],
    [
      {
        "value": 76.288,
        "value_name": None
      },
      {
        "value": 79.567,
        "value_name": None
      }
    ],
    [
      {
        "value": 71.078,
        "value_name": None
      },
      {
        "value": 73.006,
        "value_name": None
      }
    ],
    [
      {
        "value": 66.553,
        "value_name": None
      },
      {
        "value": 69.531,
        "value_name": None
      }
    ],
    [
      {
        "value": 54.807,
        "value_name": None
      },
      {
        "value": 79.978,
        "value_name": None
      }
    ],
    [
      {
        "value": 62.176,
        "value_name": None
      },
      {
        "value": 63.513,
        "value_name": None
      }
    ],
    [
      {
        "value": 62.769,
        "value_name": None
      },
      {
        "value": 62.872,
        "value_name": None
      }
    ],
    [
      {
        "value": 55.435,
        "value_name": None
      },
      {
        "value": 55.774,
        "value_name": None
      }
    ],
    [
      {
        "value": 44.772,
        "value_name": None
      },
      {
        "value": 42.732,
        "value_name": None
      }
    ],
    [
      {
        "value": 40.883,
        "value_name": None
      },
      {
        "value": 44.428,
        "value_name": None
      }
    ],
    [
      {
        "value": 30.541,
        "value_name": None
      },
      {
        "value": 48.308,
        "value_name": None
      }
    ],
    [
      {
        "value": 36.566,
        "value_name": None
      },
      {
        "value": 36.982,
        "value_name": None
      }
    ],
    [
      {
        "value": 35.675,
        "value_name": None
      },
      {
        "value": 32.603,
        "value_name": None
      }
    ],
    [
      {
        "value": 29.885,
        "value_name": None
      },
      {
        "value": 35.697,
        "value_name": None
      }
    ],
    [
      {
        "value": 28.7,
        "value_name": None
      },
      {
        "value": 24.777,
        "value_name": None
      }
    ],
    [
      {
        "value": 25.202,
        "value_name": None
      },
      {
        "value": 25.986,
        "value_name": None
      }
    ],
    [
      {
        "value": 23.97,
        "value_name": None
      },
      {
        "value": 21.7,
        "value_name": None
      }
    ],
    [
      {
        "value": 23.563,
        "value_name": None
      },
      {
        "value": 20.99,
        "value_name": None
      }
    ],
    [
      {
        "value": 20.851,
        "value_name": None
      },
      {
        "value": 20.204,
        "value_name": None
      }
    ],
    [
      {
        "value": 17.572,
        "value_name": None
      },
      {
        "value": 19.341,
        "value_name": None
      }
    ],
    [
      {
        "value": 12.401,
        "value_name": None
      },
      {
        "value": 10.558,
        "value_name": None
      }
    ],
    [
      {
        "value": 11.174,
        "value_name": None
      },
      {
        "value": 10.683,
        "value_name": None
      }
    ],
    [
      {
        "value": 10.746,
        "value_name": None
      },
      {
        "value": 10.362,
        "value_name": None
      }
    ],
    [
      {
        "value": 9.992,
        "value_name": None
      },
      {
        "value": 9.819,
        "value_name": None
      }
    ],
    [
      {
        "value": 6.847,
        "value_name": None
      },
      {
        "value": 6.019,
        "value_name": None
      }
    ],
    [
      {
        "value": 5.116,
        "value_name": None
      },
      {
        "value": 6.482,
        "value_name": None
      }
    ],
    [
      {
        "value": 4.309,
        "value_name": None
      },
      {
        "value": 5.723,
        "value_name": None
      }
    ],
    [
      {
        "value": 4.62,
        "value_name": None
      },
      {
        "value": 4.64,
        "value_name": None
      }
    ],
    [
      {
        "value": 3.624,
        "value_name": None
      },
      {
        "value": 5.269,
        "value_name": None
      }
    ],
    [
      {
        "value": 4.347,
        "value_name": None
      },
      {
        "value": 3.956,
        "value_name": None
      }
    ],
    [
      {
        "value": 58.354,
        "value_name": None
      },
      {
        "value": 69.877,
        "value_name": None
      }
    ],
    [
      {
        "value": 19.16,
        "value_name": None
      },
      {
        "value": 18.379,
        "value_name": None
      }
    ],
    [
      {
        "value": 16.725,
        "value_name": None
      },
      {
        "value": 16.91,
        "value_name": None
      }
    ],
    [
      {
        "value": 9.199,
        "value_name": None
      },
      {
        "value": 9.207,
        "value_name": None
      }
    ],
    [
      {
        "value": 5.283,
        "value_name": None
      },
      {
        "value": 5.185,
        "value_name": None
      }
    ],
    [
      {
        "value": 4.624,
        "value_name": None
      },
      {
        "value": 4.508,
        "value_name": None
      }
    ],
    [
      {
        "value": 0.001,
        "value_name": None
      },
      {
        "value": 0.036,
        "value_name": None
      }
    ]
  ]
}