import uuid
import unittest
from unittest.mock import Mock

from texpraxconnector import teamboard_requests
from texpraxconnector.teamboard_requests import TeamboardConnector

class ConnectorTestCase(unittest.TestCase):
    def setUp(self) -> None:
        self.connector = TeamboardConnector(teamboard_requests.login_data_real, use_real=True)
        self.connector.set_group("Key User")

    def test_save_problem(self) -> None:
        self.connector.create_problem(f"DELETEME {uuid.uuid4()}")

    def test_save_full(self) -> None:
        subj_text = f"DELETEME {uuid.uuid4()}"

        self.connector.create_problem(subj_text)
        self.connector.add_cause(subj_text, "DELETME_CAUSE")
        self.connector.add_solution(subj_text, "DELETME_SOLUTION")

    def test_save_non_existent(self) -> None:
        subj_text = f"DELETEME_FAKE"

        self.connector.create_problem(subj_text)
        self.connector.add_cause(subj_text + "_CAUSE", "DELETME_CAUSE")
        self.connector.add_solution(subj_text + "_SOL", "DELETME_SOLUTION")

if __name__ == "__main__":
    unittest.main()

# TODO Log Command in Bot implmentieren