/*
 * Decompiled with CFR 0.152.
 */
import edu.cmu.meteor.scorer.MeteorConfiguration;
import edu.cmu.meteor.scorer.MeteorScorer;
import edu.cmu.meteor.scorer.MeteorStats;
import edu.cmu.meteor.util.Constants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trainer {
    public static final double[] INITIAL = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0};
    public static final double[] FINAL = new double[]{1.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    public static final double[] STEP = new double[]{0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05};
    private static final double e = 0.001;
    private static final DecimalFormat df = new DecimalFormat("0.00");
    private static ArrayList<Double> initialWeights;
    private static ArrayList<Double> finalWeights;
    private static ArrayList<Double> step;
    private static ArrayList<MeteorStats> statsList;
    private static ArrayList<Double> terList;
    private static ArrayList<Double> lengthList;
    private static ArrayList<ArrayList<Integer>> gtList;
    private static ArrayList<Double> gtWeightList;
    private static double eps;
    private static String language;
    private static MeteorConfiguration config;
    private static ArrayList<Double> weights;
    private static PrintStream out;

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Meteor Trainer version 1.5");
            System.out.println("Usage: java -XX:+UseCompressedOops -Xmx2G -cp meteor-*.jar Trainer <task> <dataDir> [options]");
            System.out.println();
            System.out.println("Tasks:\t\t\t\tOne of: segcor spearman rank");
            System.out.println();
            System.out.println("Options:");
            System.out.println("-a paraphrase");
            System.out.println("-e epsilon");
            System.out.println("-l language");
            System.out.println("-ch\t\t\t\tfor character-based P and R");
            System.out.println("-noNorm\t\t\t\tdon't normalize, sgm files are pre-tokenized");
            System.out.println("-multi\t\t\t\tmulti-language.  Use noNorm and language-specific words/paraphrases");
            System.out.println("-i 'p1 p2 p3 p4 w1 w2 w3 w4'\tInitial parameters and weights");
            System.out.println("-f 'p1 p2 p3 p4 w1 w2 w3 w4'\tFinal parameters and weights");
            System.out.println("-s 'p1 p2 p3 p4 w1 w2 w3 w4'\tSteps");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        initialWeights = new ArrayList();
        for (double d : INITIAL) {
            initialWeights.add(d);
        }
        finalWeights = new ArrayList();
        for (double d : FINAL) {
            finalWeights.add(d);
        }
        step = new ArrayList();
        double[] dArray = STEP;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double d;
            d = dArray[i];
            step.add(d);
        }
        int n2 = 2;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-i")) {
                initialWeights = Trainer.makePaddedList(stringArray[n2 + 1]);
                n2 += 2;
                continue;
            }
            if (stringArray[n2].equals("-f")) {
                finalWeights = Trainer.makePaddedList(stringArray[n2 + 1]);
                n2 += 2;
                continue;
            }
            if (stringArray[n2].equals("-s")) {
                step = Trainer.makePaddedList(stringArray[n2 + 1]);
                n2 += 2;
                continue;
            }
            if (stringArray[n2].equals("-a")) {
                string3 = stringArray[n2 + 1];
                n2 += 2;
                continue;
            }
            if (stringArray[n2].equals("-e")) {
                eps = Double.parseDouble(stringArray[n2 + 1]);
                n2 += 2;
                continue;
            }
            if (stringArray[n2].equals("-l")) {
                language = stringArray[n2 + 1];
                n2 += 2;
                continue;
            }
            if (stringArray[n2].equals("-ch")) {
                bl = true;
                ++n2;
                continue;
            }
            if (stringArray[n2].equals("-noNorm")) {
                bl2 = true;
                ++n2;
                continue;
            }
            if (stringArray[n2].equals("-multi")) {
                bl2 = true;
                bl3 = true;
                ++n2;
                continue;
            }
            System.err.println("Unknown option \"" + stringArray[n2] + "\"");
            System.exit(1);
        }
        if (string3.equals("")) {
            string3 = Constants.getDefaultParaFileURL(Constants.getLanguageID(Constants.normLanguageName(language))).getFile();
        }
        for (n = 0; n < finalWeights.size(); ++n) {
            finalWeights.set(n, finalWeights.get(n) + 0.001);
        }
        if (string.equals("segcor")) {
            Trainer.segcor(string2, string3, bl, bl2, false);
        } else if (string.equals("spearman")) {
            Trainer.segcor(string2, string3, bl, bl2, true);
        } else if (string.equals("rank")) {
            Trainer.rank(string2, string3, bl, bl2, bl3);
        } else {
            System.err.println("Please specify a valid task");
            System.exit(1);
        }
    }

    private static void segcor(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        statsList = new ArrayList();
        terList = new ArrayList();
        lengthList = new ArrayList();
        File file = new File(string);
        String string3 = "";
        String string4 = "";
        for (String string5 : file.list()) {
            String string6;
            String string7;
            StringTokenizer stringTokenizer;
            String string8;
            BufferedReader fileNotFoundException;
            if (!string5.endsWith(".ter")) continue;
            String string9 = string5.split("\\.")[0];
            System.err.println(string9);
            string3 = string + "/" + string9 + ".tst";
            string4 = string + "/" + string9 + ".ref";
            Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
            try {
                fileNotFoundException = new BufferedReader(new FileReader(string + "/" + string5));
                while ((string8 = fileNotFoundException.readLine()) != null) {
                    stringTokenizer = new StringTokenizer(string8);
                    string7 = stringTokenizer.nextToken();
                    string6 = stringTokenizer.nextToken();
                    double string10 = Double.parseDouble(stringTokenizer.nextToken());
                    hashtable.put(string7 + ":" + string6, string10);
                }
                fileNotFoundException.close();
            }
            catch (FileNotFoundException iOException) {
                System.err.println("Error: If you are viewing this error message, please check your filesystem and Java installation.");
                System.exit(1);
            }
            catch (IOException fileNotFoundException2) {
                fileNotFoundException2.printStackTrace();
                System.exit(1);
            }
            Meteor.main(Trainer.getMArgs(string3, string4, string2, bl, bl2, false));
            try {
                fileNotFoundException = new BufferedReader(new FileReader("meteor-seg.scr"));
                while ((string8 = fileNotFoundException.readLine()) != null) {
                    stringTokenizer = new StringTokenizer(string8, "\t");
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    string7 = stringTokenizer.nextToken();
                    string6 = stringTokenizer.nextToken();
                    String string10 = stringTokenizer.nextToken();
                    MeteorStats meteorStats = new MeteorStats(string10);
                    statsList.add(meteorStats);
                    double d = (Double)hashtable.get(string7 + ":" + string6);
                    terList.add(d);
                    lengthList.add(meteorStats.referenceLength);
                }
                fileNotFoundException.close();
                new File("meteor-seg.scr").delete();
                new File("meteor-doc.scr").delete();
                new File("meteor-sys.scr").delete();
            }
            catch (FileNotFoundException iOException) {
                System.err.println("Error: System name and file name do not match for \"" + string9 + "\"");
                System.exit(1);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
        }
        config = new MeteorConfiguration();
        config.setCharBased(bl);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        config.setModules(arrayList);
        weights = new ArrayList<Double>(initialWeights);
        int n = 0;
        Trainer.rescore(n, bl3);
    }

    private static void rescore(int n, boolean bl) {
        if (n == step.size()) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(weights.get(0));
            arrayList.add(weights.get(1));
            arrayList.add(weights.get(2));
            arrayList.add(weights.get(3));
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            arrayList2.add(weights.get(4));
            arrayList2.add(weights.get(5));
            arrayList2.add(weights.get(6));
            arrayList2.add(weights.get(7));
            config.setParameters(arrayList);
            config.setModuleWeights(arrayList2);
            MeteorScorer meteorScorer = new MeteorScorer(config);
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            for (int i = 0; i < statsList.size(); ++i) {
                MeteorStats meteorStats = statsList.get(i);
                meteorScorer.computeMetrics(meteorStats);
                arrayList3.add(meteorStats.score);
            }
            double d = bl ? Trainer.spearman(arrayList3, terList) : Trainer.pearsonWeighted(arrayList3, terList, lengthList);
            out.print(d);
            for (Double d2 : weights) {
                out.print(" " + df.format(d2));
            }
            out.println();
            return;
        }
        for (double d = initialWeights.get(n).doubleValue(); d <= finalWeights.get(n); d += step.get(n).doubleValue()) {
            weights.set(n, d);
            Trainer.rescore(n + 1, bl);
        }
    }

    private static double spearman(ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        int n = arrayList.size();
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = new double[]{arrayList.get(i), arrayList2.get(i)};
        }
        Arrays.sort(dArrayArray, new xyComparatorX());
        Trainer.rankArray(dArrayArray, 0);
        Arrays.sort(dArrayArray, new xyComparatorY());
        Trainer.rankArray(dArrayArray, 1);
        return Trainer.pearson(dArrayArray);
    }

    private static void rankArray(double[][] dArray, int n) {
        double d = 0.0;
        int n2 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            d += (double)(i + 1);
            ++n2;
            if (i != dArray.length - 1 && dArray[i][n] == dArray[i + 1][n]) continue;
            for (int j = 0; j < n2; ++j) {
                dArray[i - j][n] = d / (double)n2;
            }
            d = 0.0;
            n2 = 0;
        }
    }

    private static double pearson(double[][] dArray) {
        int n = dArray.length;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i][0];
            d2 += dArray[i][1];
        }
        double d3 = d / (double)n;
        double d4 = d2 / (double)n;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < n; ++i) {
            d5 += (dArray[i][0] - d3) * (dArray[i][1] - d4);
            d6 += (dArray[i][0] - d3) * (dArray[i][0] - d3);
            d7 += (dArray[i][1] - d4) * (dArray[i][1] - d4);
        }
        double d8 = d5 / (double)n;
        double d9 = d6 / (double)n;
        double d10 = d7 / (double)n;
        double d11 = d8 / Math.sqrt(d9 * d10);
        if (Double.isNaN(d11)) {
            return 0.0;
        }
        return d11;
    }

    private static double pearsonWeighted(ArrayList<Double> arrayList, ArrayList<Double> arrayList2, ArrayList<Double> arrayList3) {
        int n = arrayList3.size();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += arrayList.get(i) * arrayList3.get(i);
            d2 += arrayList2.get(i) * arrayList3.get(i);
            d3 += arrayList3.get(i).doubleValue();
        }
        double d4 = d / d3;
        double d5 = d2 / d3;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        for (int i = 0; i < n; ++i) {
            d6 += arrayList3.get(i) * (arrayList.get(i) - d4) * (arrayList2.get(i) - d5);
            d7 += arrayList3.get(i) * (arrayList.get(i) - d4) * (arrayList.get(i) - d4);
            d8 += arrayList3.get(i) * (arrayList2.get(i) - d5) * (arrayList2.get(i) - d5);
        }
        double d9 = d6 / d3;
        double d10 = d7 / d3;
        double d11 = d8 / d3;
        double d12 = d9 / Math.sqrt(d10 * d11);
        if (Double.isNaN(d12)) {
            return 0.0;
        }
        return d12;
    }

    private static void rank(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        String string3;
        String string4;
        Object object;
        String string5;
        Object[] objectArray;
        String string6;
        Object iOException;
        statsList = new ArrayList();
        lengthList = new ArrayList();
        Hashtable hashtable = new Hashtable();
        int n = 0;
        String string7 = "";
        String string8 = "";
        String string9 = "";
        File file = new File(string);
        for (String string10 : file.list()) {
            if (string10.endsWith(".rank") || string10.endsWith(".ref.sgm")) continue;
            string7 = string10.substring(0, string10.indexOf(".")) + ".ref.sgm";
            string8 = string10.substring(0, string10.indexOf("."));
            string9 = string10.substring(string10.indexOf(".") + 1, string10.lastIndexOf("."));
            iOException = string + "/" + string10;
            string6 = string + "/" + string7;
            objectArray = Trainer.getMArgs((String)iOException, string6, string2, bl, bl2, bl3);
            System.err.println(Arrays.toString(objectArray));
            Meteor.main((String[])objectArray);
            if (!hashtable.containsKey(string8)) {
                hashtable.put(string8, new Hashtable());
            }
            if (!((Hashtable)hashtable.get(string8)).containsKey(string9)) {
                ((Hashtable)hashtable.get(string8)).put(string9, new Hashtable());
            }
            try {
                iOException = new BufferedReader(new FileReader("meteor-seg.scr"));
                while ((string5 = ((BufferedReader)iOException).readLine()) != null) {
                    object = new StringTokenizer(string5, "\t");
                    ((StringTokenizer)object).nextToken();
                    ((StringTokenizer)object).nextToken();
                    ((StringTokenizer)object).nextToken();
                    string4 = ((StringTokenizer)object).nextToken();
                    string3 = ((StringTokenizer)object).nextToken();
                    MeteorStats meteorStats = new MeteorStats(string3);
                    statsList.add(meteorStats);
                    ((Hashtable)((Hashtable)hashtable.get(string8)).get(string9)).put(string4, n);
                    ++n;
                    lengthList.add(meteorStats.referenceLength);
                }
                ((BufferedReader)iOException).close();
                new File("meteor-seg.scr").delete();
                new File("meteor-doc.scr").delete();
                new File("meteor-sys.scr").delete();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Error: System name and file name do not match for \"" + string9 + "\"");
                System.exit(1);
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
                System.exit(1);
            }
        }
        gtList = new ArrayList();
        gtWeightList = new ArrayList();
        for (String string10 : file.list()) {
            if (!string10.endsWith(".rank")) continue;
            System.err.println(string10);
            try {
                iOException = new BufferedReader(new FileReader(string + "/" + string10));
                string6 = "";
                while ((string6 = ((BufferedReader)iOException).readLine()) != null) {
                    objectArray = new StringTokenizer(string6, "\t");
                    iOException = objectArray.nextToken();
                    string5 = objectArray.nextToken();
                    object = objectArray.nextToken();
                    string4 = objectArray.nextToken();
                    string3 = objectArray.nextToken();
                    if (!((Hashtable)hashtable.get(string5)).containsKey(object) || !((Hashtable)hashtable.get(string4)).containsKey(string3)) continue;
                    int n2 = (Integer)((Hashtable)((Hashtable)hashtable.get(string5)).get(object)).get(iOException);
                    int n3 = (Integer)((Hashtable)((Hashtable)hashtable.get(string4)).get(string3)).get(iOException);
                    double d = (lengthList.get(n2) + lengthList.get(n3)) / 2.0;
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    arrayList.add(n2);
                    arrayList.add(n3);
                    gtList.add(arrayList);
                    gtWeightList.add(d);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                System.exit(1);
            }
            catch (IOException iOException3) {
                iOException3.printStackTrace();
                System.exit(1);
            }
        }
        config = new MeteorConfiguration();
        config.setCharBased(bl);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        config.setModules(arrayList);
        weights = new ArrayList<Double>(initialWeights);
        int n4 = 0;
        Trainer.rerank(n4);
    }

    private static void rerank(int n) {
        if (n == step.size()) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(weights.get(0));
            arrayList.add(weights.get(1));
            arrayList.add(weights.get(2));
            arrayList.add(weights.get(3));
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            arrayList2.add(weights.get(4));
            arrayList2.add(weights.get(5));
            arrayList2.add(weights.get(6));
            arrayList2.add(weights.get(7));
            config.setParameters(arrayList);
            config.setModuleWeights(arrayList2);
            MeteorScorer meteorScorer = new MeteorScorer(config);
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            for (int i = 0; i < statsList.size(); ++i) {
                MeteorStats meteorStats = statsList.get(i);
                meteorScorer.computeMetrics(meteorStats);
                arrayList3.add(meteorStats.score);
            }
            double d = Trainer.kendall(arrayList3);
            out.print(d);
            for (Double d2 : weights) {
                out.print(" " + df.format(d2));
            }
            out.println();
            return;
        }
        for (double d = initialWeights.get(n).doubleValue(); d <= finalWeights.get(n); d += step.get(n).doubleValue()) {
            weights.set(n, d);
            Trainer.rerank(n + 1);
        }
    }

    private static double kendall(ArrayList<Double> arrayList) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < gtList.size(); ++i) {
            ArrayList<Integer> arrayList2 = gtList.get(i);
            double d3 = arrayList.get(arrayList2.get(0)) - arrayList.get(arrayList2.get(1));
            if (d3 > eps) {
                d += 1.0;
            }
            d2 += 1.0;
        }
        return (d - (d2 - d)) / d2;
    }

    private static ArrayList<Double> makePaddedList(String string) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(Double.parseDouble(stringTokenizer.nextToken()));
        }
        while (arrayList.size() < INITIAL.length) {
            arrayList.add(0.0);
        }
        return arrayList;
    }

    private static String[] getMArgs(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        int n = Constants.getLanguageID(Constants.normLanguageName(language));
        ArrayList<Integer> arrayList = Constants.getModules(n, Constants.getDefaultTask(n));
        String string4 = "";
        String string5 = "";
        String[] stringArray = arrayList.iterator();
        while (stringArray.hasNext()) {
            int n2 = stringArray.next();
            string4 = string4 + Constants.getModuleName(n2) + " ";
            if (string5.equals("")) {
                string5 = "1.0 ";
                continue;
            }
            string5 = string5 + "0.5 ";
        }
        string4 = string4.trim();
        string5 = string5.trim();
        stringArray = new String[]{string, string2, "-sgml", "-ssOut", "-l", language, "-m", string4, "-a", string3, "-w", string5, "-p", "0.5 0.5 0.5 0.5"};
        if (bl) {
            stringArray = Arrays.copyOf(stringArray, stringArray.length + 1);
            stringArray[stringArray.length - 1] = "-ch";
        }
        if (!bl2) {
            stringArray = Arrays.copyOf(stringArray, stringArray.length + 1);
            stringArray[stringArray.length - 1] = "-norm";
        }
        if (bl3) {
            String string6 = new File(string).getName();
            String string7 = string6.substring(string6.indexOf("-") + 1, string6.indexOf("-") + 3);
            String[] stringArray2 = new String[]{string, string2, "-sgml", "-ssOut", "-l", string7, "-m", "exact paraphrase", "-a", Constants.getDefaultParaFileURL(Constants.getLanguageID(Constants.normLanguageName(string7))).getFile(), "-w", "1.0 0.5", "-p", "0.5 0.5 0.5 0.5", "-lower"};
            return stringArray2;
        }
        return stringArray;
    }

    static {
        eps = 0.0;
        language = "en";
        out = new PrintStream(System.out, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class xyComparatorY
    implements Comparator<double[]> {
        private xyComparatorY() {
        }

        @Override
        public int compare(double[] dArray, double[] dArray2) {
            return Double.compare(dArray[1], dArray2[1]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class xyComparatorX
    implements Comparator<double[]> {
        private xyComparatorX() {
        }

        @Override
        public int compare(double[] dArray, double[] dArray2) {
            return Double.compare(dArray[0], dArray2[0]);
        }
    }
}

