
data {
  int num_data;
  int num_basis;
  //basis for cumulative spine, with values at each score that is used
  //generate this in R using something like
  //t(ibs(score, knots=append(seq(0.1,0.9,0.1),0.95), degree=3, intercept = TRUE,Boundary.knots = c(0,1)))
  matrix[num_basis, num_data] I;
  
  //annotated data, 0=false, 1=true
  int annotated[num_data];
  
  //flag to return just draws from the prior distirbution without recompiling
  int justprior;
}
parameters {
  row_vector[num_basis] loga;
  real logb;
}
transformed parameters {
  row_vector[num_basis] a;
  real b;
  vector[num_data] C;

  //a are the spline amplitudes
  a = exp(loga);
  //b is the y intercept
  b = exp(logb);
  //C is the value of the recalibration curve at the data points
  //we use the logit (sigmoid) transfer function to keep results between 0 and 1
  C = 2*inv_logit(to_vector(a*I)+b) -1 ;
}
model {
  // use lognormal prior for spline amplitudes and intercept
  loga ~ normal(0,2);
  logb ~ normal(0,2);
  if(justprior==0) {
    for(d in 1:(num_data)) {
      //The model is
      //x ~ bernoulli(C[d]); observe(x=annotated[d])
      //This has to be slightly encoded in stan,
      //as follows: 
      target += log(annotated[d] ? C[d] : 1-C[d]);
  }}
}

