/*
 * Decompiled with CFR 0.152.
 */
package babel.prep;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;

public abstract class PrepStep
extends Configured {
    protected FileSystem m_fs = FileSystem.get((Configuration)this.getConf());

    public PrepStep() throws IOException {
        this((Configuration)new JobConf(PrepStep.class));
        this.m_fs = FileSystem.get((Configuration)this.getConf());
    }

    public PrepStep(Configuration conf) throws IOException {
        super((Configuration)new JobConf(conf, PrepStep.class));
    }

    public void configure(JobConf job) throws Exception {
        this.setConf((Configuration)job);
        this.m_fs = FileSystem.get((Configuration)this.getConf());
    }

    public void runPrepStep(JobConf job) throws IOException {
        JobClient.runJob((JobConf)job);
        this.cleanUpAfterJob(job);
    }

    protected void cleanUpAfterJob(JobConf job) throws IOException {
        this.m_fs.close();
    }

    protected String getCurTimeStamp() {
        return new SimpleDateFormat("yyMMdd-HHmmss").format(Calendar.getInstance().getTime());
    }

    protected void setUniqueTempDir(JobConf job) {
        Path tempDir = new Path(String.valueOf(this.getConf().get("hadoop.tmp.dir", ".")) + "/" + UUID.randomUUID().toString());
        job.set("hadoop.tmp.dir", tempDir.toString());
    }

    protected String dumpJobProps(JobConf job) {
        Iterator it = job.iterator();
        StringBuilder strBld = new StringBuilder();
        while (it.hasNext()) {
            Map.Entry cur = (Map.Entry)it.next();
            strBld.append(String.valueOf((String)cur.getKey()) + " : " + (String)cur.getValue() + "\n");
        }
        return strBld.toString();
    }
}

