from pathlib import Path
import json


class PromptTemplate:
    def __init__(self, template, scale_min, scale_max):
        self.template = template
        self.scale_min = scale_min
        self.scale_max = scale_max

    def __iter__(self):
        yield from {
            "template": self.template,
            "scale_min": self.scale_min,
            "scale_max": self.scale_max,
        }.items()

    def __str__(self):
        return json.dumps(dict(self), ensure_ascii=False)

    def __repr__(self):
        return self.__str__()

    def to_json(self):
        return self.__str__()

    @staticmethod
    def from_json(json_dict):
        return PromptTemplate(json_dict['template'], json_dict['scale_min'], json_dict['scale_max'])

    @staticmethod
    def get_prompts(evaluation_aspect):
        prompts_folder = Path('prompts')
        with open(prompts_folder.joinpath(evaluation_aspect + '.json')) as file:
            prompts = json.load(file, object_hook=PromptTemplate.from_json)
        return prompts
