from random import shuffle, random, randint, sample, choice
import string
from typing import List, Tuple, Dict
import itertools
colors = ['Red', 'Blue', 'Green', 'Yellow', 'Orange', 'Purple', 'Pink', 'Brown', 'Black', 'White', 'Gray', 'Silver', 'Gold', 'Indigo', 'Turquoise', 'Cyan', 'Magenta', 'Lavender', 'Maroon', 'Beige', 'Teal', 'Navy', 'Olive', 'Coral', 'Salmon', 'Peach', 'Ivory', 'Tan', 'Lilac', 'Skyblue', 'Mint', 'Slate', 'Turmeric', 'Ruby', 'Emerald', 'Tangerine', 'Pewter', 'Champagne', 'Mauve', 'Brick', 'Forest', 'Mustard', 'Chocolate', 'Sapphire', 'Blush', 'Ash', 'Coral', 'Steel', 'Apricot', 'Pearl']

def caesar_encrypt(text, shift=3):
    encrypted_text = ""
    for char in text:
        if char.isalpha():
            ascii_offset = ord('A') if char.isupper() else ord('a')
            encrypted_char = chr((ord(char) - ascii_offset + shift) % 26 + ascii_offset)
            encrypted_text += encrypted_char
        else:
            encrypted_text += char
    return encrypted_text

def caesar_cipher_table(shift=3):
    encrypt = caesar_encrypt("ABCDEFGHIJKLMNOPQRSTUVWXYZ", shift)
    table = []
    for en, de in zip(encrypt, string.ascii_uppercase):
        table.append([de, en])
    return table


def color_preference_generation(colors):
    shuffle(colors)
    color_preferences = {}
    rank = 1
    for color in colors:
        color_preferences[color] = rank
        rank += 1
    return color_preferences



