import os
import pandas as pd
import torch
import torch.nn as nn
from datasets import load_dataset
from tqdm import tqdm
import time
from timeout_decorator import timeout
import openai
openai.api_key = "Your OpenAI API"

@timeout(15)
def chatGPT(prompt):
    res = openai.ChatCompletion.create(
                    model="gpt-3.5-turbo",
                    messages=[
                    {"role": "system", "content": prompt},
                    ],
                    temperature=0,
                    max_tokens=5)

    return res

###########################################################
f = 'Enter file path'

df = pd.read_excel(f)
# df = df[df.columns[:8]] # choose this based on the dataset

df = df.sample(n=500, random_state=42).reset_index(drop=True)

dft = df.text

anno = []
for i in tqdm(range(df.shape[0])):
    prompt = dft.iloc[i]+" Answer in one word only."

    try:
        response = chatGPT(prompt)
    except:
        print('sleep')
        time.sleep(30)
        print('here we go...')
        try:
            response = chatGPT(prompt)
        except:
            print('sleep')
            time.sleep(30)
            print('here we go...')
            response = chatGPT(prompt)
                    
    anno += [response["choices"][0]["message"]["content"].lower()]


df[_Name column_] = anno
df.to_excel(f, index=False)