theory question_52_3
```
theorem hypothesis:
  (* Premise: A student standing near a campfire feels warmer as the fire grows. *)
  assumes asm: "Student(x) ∧ Campfire(y) ∧ Near(z, x, y) ∧ Grows(y) ∧ (Stands(e, x, z) ∧ Feels(f, x) ∧ Warmer(f) ∧ Agent(e, x) ∧ Patient(e, z))"
  (* Hypothesis: Radiation is the process that transfers heat from the campfire to the student. *)
  shows "∃x y z e. Radiation(x) ∧ Process(y) ∧ Campfire(z) ∧ Student(e) ∧ (Transfers(f) ∧ Agent(f, x) ∧ Patient(f, z) ∧ Patient(f, e))"
proof -
  fix x y z f
  assume Radiation x ∧ Process y ∧ Campfire z ∧ Student e
  then have fire_is_campfire: "Fire z" using explanation_3 by simp
  then have heat_transfer_through_waves: "Transfers_heat_through_waves z" using explanation_2 by simp
  then have radiation: "Radiation z" using explanation_5 by simp
  then have process: "Process y" using assumption by simp
  then have patient_student: "Patient (f::process) e"
    apply (rule PatientI)
    apply (rule agent_patient_same_entity)
    apply (rule patient_agent_same_entity)
    apply (rule patient_patient_same_entity)
    apply (rule process)
    done
  then have patient_fire: "Patient (f::process) z"
    apply (rule PatientI)
    apply (rule agent_patient_same_entity)
    apply (rule patient_agent_same_entity)
    apply (rule patient_patient_same_entity)
    apply (rule fire_is_campfire)
    done
  then show "∃f. Transfers f ∧ Agent f x ∧ Patient f z ∧ Patient f e" using patient_fire patient_student radiation process by blast
qed
```