theory question_93_1
imports Main

begin

typedecl entity

consts
  Adult :: "entity ⇒ bool"
  Echinoderms :: "entity ⇒ bool"
  RadialSymmetry :: "entity ⇒ bool"
  Starfish :: "entity ⇒ bool"
  Adults :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Adult echinoderms, which include starfish, have radial symmetry. *)
axiomatization where
  explanation_1: "∀x. Adult x ∧ Echinoderms x ⟶ RadialSymmetry x"

(* Explanation 2: Starfish are a type of echinoderm. *)
axiomatization where
  explanation_2: "∀x. Starfish x ⟶ Echinoderms x"

(* Explanation 3: Echinoderms with radial symmetry include adult starfish. *)
axiomatization where
  explanation_3: "∀x. Echinoderms x ∧ RadialSymmetry x ⟶ Adults x (Starfish x)"

theorem hypothesis:
  assumes asm: "Adult x ∧ Starfish x"
  (* Hypothesis: Adults of starfish have radial symmetry. *)
  shows "RadialSymmetry x"
proof -
  from asm have "Adult x ∧ Echinoderms x" by simp
  then have "RadialSymmetry x" using explanation_1 by blast
qed

end
