theory question_86_0
imports Main

begin

typedecl entity
typedecl event

consts
  Glucose :: "entity ⇒ bool"
  Uses :: "entity ⇒ entity ⇒ bool"
  Organism :: "event ⇒ bool"

theorem hypothesis:
  assumes asm: "Organism x"
  (* Hypothesis: Most organisms use sugar as energy. *)
  shows "∃x. Organism x ∧ Uses x Glucose"
proof -
  from asm have "Organism x" by simp
  then have "Uses (entity_ constant 'glucose') x" using most_organisms_use_sugar by blast
  then have "Uses x Glucose" by simp
  show ?thesis using asm `Uses x Glucose` by blast
qed

(* Explanation: Most organisms use sugar as energy. *)
axiomatization where
  most_organisms_use_sugar: "∀x. Organism x ⟶ Uses (entity_ constant 'glucose') x"

end
