theory question_30_0

imports Main

begin

typedecl entity
typedecl event

consts
  TricksOnSkateboard :: "entity ⇒ entity ⇒ bool"
  Doing :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Human :: "entity ⇒ bool"
  Tricks :: "entity ⇒ bool"
  Instrument :: "event ⇒ entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Skateboard :: "entity ⇒ bool"

(* Explanation 1: ∀y z. TricksOnSkateboard(y, z) ⟶ Doing(e2) ∧ Patient(e2, y) *)
axiomatization where
  explanation_1: "∀y z. TricksOnSkateboard y z ⟶ (∃e2. Doing e2 ∧ Patient e2 y)"

theorem hypothesis:
  (* Premise: ∃x y z e1 e2. Man(x) ∧ Skateboard(z) ∧ Tricks(y) ∧ Doing(e1) ∧ Agent(e1, x) ∧ Patient(e1, y) ∧ Instrument(e1, z) ∧ TricksOnSkateboard(y, z) ∧ Doing(e2) ∧ Agent(e2, x) ∧ Patient(e2, y) *)
  assumes asm: "Man x ∧ Skateboard z ∧ Tricks y ∧ Doing e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Instrument e1 z ∧ TricksOnSkateboard y z ∧ Doing e2 ∧ Agent e2 x ∧ Patient e2 y"
  (* Hypothesis: ∃x y e1. Human(x) ∧ Tricks(y) ∧ Doing(e1) ∧ Agent(e1, x) ∧ Patient(e1, y) *)
  shows "∃x y e1. Human x ∧ Tricks y ∧ Doing e1 ∧ Agent e1 x ∧ Patient e1 y"
proof -
  from asm have "Man x" by fastforce
  then have "Human x" by simp
  have "∃e1. Doing e1 ∧ Agent e1 x ∧ Patient e1 y" using asm by blast
  have "TricksOnSkateboard y z" using asm by blast
  have "∃e2. Doing e2 ∧ Patient e2 y" using explanation_1 TricksOnSkateboard y z by blast
  then have "∃e3. Doing e3 ∧ Agent e3 x ∧ Patient e3 y" by (rule exI[of _ e2])
  then have "∃e4. Doing e4 ∧ Agent e4 x ∧ Patient e4 y ∧ Instrument e4 z" using asm by blast
  then show ?thesis using `Human x` `Tricks y` `Doing e4` `Agent e4 x` `Patient e4 y` by blast
qed

end
