theory question_27_2
imports Main

begin

typedecl entity
typedecl event

consts
  Sidewalk :: "entity ⇒ bool"
  OutdoorLocation :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Old :: "entity ⇒ bool"
  HardwareParts :: "entity ⇒ bool"
  Sells :: "event ⇒ entity ⇒ entity ⇒ bool"
  Dirty :: "entity ⇒ bool"

(* Explanation 1: A sidewalk is an outdoor location. *)
axiomatization where
  explanation_1: "∀x. Sidewalk x ⟶ OutdoorLocation x"

(* Explanation 2: If an entity is on a sidewalk, then that entity is outside. *)
axiomatization where
  explanation_2: "∀x y. On x y ∧ Sidewalk y ⟶ Outside x"

theorem hypothesis:
  (* Premise: A old man sells hardware parts on a dirty sidewalk. *)
  assumes asm: "Man x ∧ Old x ∧ HardwareParts y ∧ Sells e x y ∧ Sidewalk z ∧ Dirty z"
  (* Hypothesis: The man is outside. *)
  shows "∃x. Man x ∧ Outside x"
proof -
  from asm have "Sidewalk z" by blast
  then have "OutdoorLocation z" using explanation_1 by blast
  from asm have "On x z" by blast
  then show ?thesis using `Man x` `OutdoorLocation z` by (rule explanation_2)
qed

end
