theory question_6_2
imports Main
begin

typedecl entity
typedecl event

consts
  Tumble :: "entity ⇒ bool"
  Watch :: "event ⇒ entity ⇒ bool"
  Spectator :: "entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  UniversityOfMichigan :: "entity ⇒ bool"

(* Explanation 1: If a man tumbles, then there exists an entity that watches him tumble. *)
axiomatization where
  explanation_1: "∀x y. Tumble x ⟶ Watch y x"

(* Explanation 2: If spectators watch a man tumble, then there exists an entity that tumbles. *)
axiomatization where
  explanation_2: "∀x y e. Spectator x ∧ Man y ∧ Tumble e ∧ Agent e y ∧ Watch e (e ▸ x)"

theorem hypothesis:
  (* Premise: A man tumbles as spectators watch at the University of Michigan. *)
  assumes asm: "Man x  ∧ Tumble e  ∧ Spectator y  ∧ Watch e  x  ∧ At e  z  ∧ UniversityOfMichigan z "
  (* Hypothesis: Spectators watch a man tumble. *)
  shows "∃x y e. Spectator x  ∧ Man y  ∧ Tumble e  ∧ Agent e  y  ∧ Watch e  e ▸ x "
proof -
  from asm have "Man x ∧ Tumble e" by blast
  then have "∃y. Watch y x" using explanation_1 by blast
  then have "∃e. Agent e y ∧ Watch e (e ▸ x)" using explanation_2 by blast
  then show ?thesis using `Spectator y` `Man y` `Tumble e` `Agent e y` `Watch e` by blast
qed

end
