theory question_90_6
imports Main
begin

typedecl entity
typedecl event

consts
  Parts :: "entity ⇒ bool"
  CarEngine :: "entity ⇒ bool"
  Friction :: "entity ⇒ bool"
  Heat :: "entity ⇒ bool"
  Causes :: "entity ⇒ entity ⇒ bool"
  Oil :: "entity ⇒ bool"
  InSystem :: "entity ⇒ bool"
  CausedBy :: "entity ⇒ entity ⇒ bool"
  Reduces :: "entity ⇒ entity ⇒ entity ⇒ bool"

(* Explanation 1: Friction between parts in a car engine causes heat. *)
axiomatization where
  explanation_1: "∀x y z e. Parts x ∧ CarEngine y ∧ Friction z ⟶ Causes e z Heat"

(* Explanation 2: Oil reduces the heat caused by friction in a system. *)
axiomatization where
  explanation_2: "∀x y z e. Oil x ∧ Heat y ∧ Friction z ∧ InSystem e ∧ CausedBy e z ⟶ Reduces x y e"

theorem hypothesis:
  (* Premise: one cause of heat in a car engine is caused by friction between parts. *)
  assumes asm: "CarEngine x ∧ Heat y ∧ Friction z ∧ Parts e ∧ InSystem e ∧ CausedBy e z Heat"
  (* Hypothesis: Oil reduces the amount of heat produced by friction. *)
  shows "∃x y z e. Oil x ∧ Heat y ∧ Friction z ∧ Reduces x y e"
proof -
  from asm have "Friction z" using explanation_1 by blast
  then have "Oil x ∧ Heat y ∧ Friction z" using asm by blast
  then obtain e where e: "InSystem e ∧ CausedBy e z" using asm by blast
  then have "Reduces x y e" using explanation_2 `Oil x ∧ Heat y ∧ Friction z` by blast
  then show ?thesis using `Oil x` `Heat y` `Friction z` by blast
qed

end
