theory question_86_1
imports Main
begin

typedecl entity
typedecl event

consts
  Snow :: "entity ⇒ bool"
  Water :: "entity ⇒ bool"
  Form :: "entity ⇒ bool"
  Temperature :: "entity ⇒ bool"
  BelowFreezing :: "entity ⇒ bool"
  Appears :: "entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: snow is a kind of ice. *)
axiomatization where
  explanation_1: "∀x. Snow x ⟶ Ice x"

(* Explanation 2: state means form. *)
axiomatization where
  explanation_2: "∀x y. State x ∧ Form y ⟶ (State x ⟷ Form y)"

theorem hypothesis:
  assumes asm: "Snow x ∧ Water y ∧ Form z ∧ Temperature e ∧ BelowFreezing e ∧ Appears e"
  (* Hypothesis: Snow is the form of water that appears when the temperature is below freezing. *)
  shows "∃x y z e. Snow x ∧ Water y ∧ Form z ∧ Temperature e ∧ BelowFreezing e ∧ Appears e ∧ Patient e x ∧ Patient e y ∧ Patient e z"
proof -
  from asm have "Snow x" and "Form z" and "Temperature e" and "BelowFreezing e" by auto
  then have "Ice x" using explanation_1 by blast
  then have "State y" using explanation_2 `Form z` by blast
  then have "Water y" using `State y` by blast
  then show ?thesis using asm `Snow x` `Water y` `Form z` `Temperature e` `BelowFreezing e` by blast
qed

end
