#!/bin/bash

for random_seed in $(seq 1 10);
do
    for ce_weight in 0.0;
    do
        for hidden_size in 500;
        do
            for entropy in 1.0;
            do
                for n_att_n_comb_n_dup in \
                    "[(6, 1, 1), (4, 15, 1)]" \
                    "[(6, 1, 1), (1, 6, 1)]" \
                    "[(1, 6, 1)]" \
                    "[(6, 1, 1), (2, 15, 1)]" \
                    "[(2, 15, 1)]" \
                    "[(6, 1, 1), (3, 20, 1)]" \
                    "[(3, 20, 1)]" \
                    "[(4, 15, 1)]" \
                    "[(6, 1, 1), (5, 6, 1)]" \
                    "[(5, 6, 1)]" 
                do
                    python EGG/egg/zoo/compo_vs_generalization/train_visual_att_val.py  \
                        --n_values=10 \
                        --n_attributes=4 \
                        --vocab_size=6 \
                        --max_len=6 \
                        --batch_size=5120 \
                        --sender_cell=gru \
                        --sender_emb=5 \
                        --sender_hidden $hidden_size \
                        --sender_entropy_coeff $entropy \
                        --receiver_cell=gru \
                        --receiver_emb=30 \
                        --receiver_hidden $hidden_size \
                        --n_epoch 15 \
                        --random_seed $random_seed \
                        --wandb_project=div_int \
                        --wandb_name "e${entropy}_h${hidden_size}_c${ce_weight}_${n_att_n_comb_n_dup}" \
                        --lr 0.001 \
                        --data_scaler 500 \
                        --n_att_n_comb_n_dup "${n_att_n_comb_n_dup}" \
                        --wandb_tags "["shape_v10"]" \
                        --validation_freq=1 \
                        --stats_freq=1 \
                        --validation_ratio 0.0 \
                        --test_ratio 0.1 \
                        --val_eval_freq 1 \
                        --test_eval_freq 1 \
                        --topsim_max_samples 3000 \
                        --final_topsim_max_samples 5000 \
                        --load_val_best false \
                        --early_stopping_thr 0.99 \
                        --eol_n_epoch 2 \
                        --eol_early_stopping_thr 2.99 \
                        --cross_entropy_weight $ce_weight \
                        --metric_max_samples 20000 \
                        --preserve_eos true \
                        --metric_exclude_eos true \
                        --attributes "['shape', 'object_hue', 'floor_hue', 'orientation', 'scale', 'wall_hue']" \
                        --use_global_seed true \
                        --loss_type mixed
                done 
            done 
        done 
    done 
done 
