### 1. Environment Setup
* Our codebase is tested on Python 3.6.13. We recommend creating a conda environment using the command given below.
```
conda create --name your_env_name python=3.6.13
```

* Our codebase is tested on GPUs with cuda version >= 10.2. Please install all of the dependencies using the command given below in the topmost directory (which contains the requirements.txt file)

```
pip install -r requirements.txt
```

### 2. Downloading Datasets
* We present results on four open-source datasets: NYT-10d, NYT-10m, Wiki-20m and DiS-ReX. To reproduce results on each of these datasets, we provide scripts in the "benchmark" folder to download them.
* For downloading NYT-10d, use the following command inside the benchmark folder
```
sh download_nyt10.sh
```
* For downloading NYT-10m, use the following command inside the benchmark folder
```
sh download_nyt10m.sh
```
* For downloading Wiki-20m, use the following command inside the benchmark folder
```
sh download_wiki20m.sh
```
* For downloading DiS-ReX, use the following command inside the benchmark folder
```
sh download_disrex.sh
```

### 3. Training and testing models

* Training scripts are provided in the topmost directory for each of the four datasets. Once the training finishes, the best saved model would automatically be tested on the test set (returning AUC, Macro F1, Micro F1, and P@M)
* To reproduce results on NYT-10d, run
```
sh train_nyt10d.sh
```
* To reproduce results on NYT-10m, run
```
sh train_nyt10m.sh
```
* To reproduce results on Wiki-20m, run
```
sh train_wiki20m.sh
```
* To reproduce results on DiS-ReX, run
```
sh train_disrex.sh
```

If you want to run just inference, add '--only_test' argument to python command for training. 
E.g. 'python main.py --pretrain_path $pretrain_path --train_file $train_file --val_file $val_file --test_file $test_file --rel2id_file $rel2id_file --batch_size $batch_size --max_epoch $max_epoch --max_length $max_length --ckpt $name --only_test'


### 4. Note (regarding gpu devide ids)
In case you don't have multiple GPUs, you need to pass the gpu id as argument to the python command in the training script. For e.g. for a single 'cuda:0' device the command is - 
'python main.py --pretrain_path $pretrain_path --train_file $train_file --val_file $val_file --test_file $test_file --rel2id_file $rel2id_file --batch_size $batch_size --max_epoch $max_epoch --max_length $max_length --ckpt $name --devs 0'
The args.devs argument specifies the list of gpu ids to train the model on. The default value is [0,1] i.e. it assumes that 'cuda:0' and 'cuda:1' are available. Kindly change it accordingly.
