/*
 * Decompiled with CFR 0.152.
 */
package ter.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ter.core.Shift;
import ter.io.SgmlProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentStringUtils {
    static String formatShiftsString(String[] hyp, String[] ref, Shift[] allshifts) {
        String to_return = "";
        String direction = "";
        if (allshifts != null) {
            for (int i = 0; i < allshifts.length; ++i) {
                int dist;
                int nend;
                int nstart;
                Shift[] oneshift = new Shift[1];
                int ostart = allshifts[i].start;
                int odest = allshifts[i].newloc;
                int oend = allshifts[i].end;
                if (odest >= oend) {
                    nstart = odest + 1 - allshifts[i].size();
                    nend = nstart + allshifts[i].size() - 1;
                    dist = odest - oend;
                    direction = "right";
                } else {
                    nstart = odest + 1;
                    nend = nstart + allshifts[i].size() - 1;
                    dist = ostart - odest - 1;
                    direction = "left";
                }
                to_return = to_return + "\nShift " + allshifts[i].shifted + " " + dist + " words " + direction;
                oneshift[0] = new Shift(ostart, oend, allshifts[i].moveto, odest);
                to_return = to_return + AlignmentStringUtils.getPraStr(hyp, ref, allshifts[i].aftershift, allshifts[i].alignment, oneshift, true);
            }
            to_return = to_return + "\n";
        }
        return to_return;
    }

    static String getPraStr(String[] hyp, String[] ref, String[] aftershift, char[] alignment, Shift[] allshifts, boolean shiftonly) {
        String to_return = "";
        String rstr = "";
        String hstr = "";
        String estr = "";
        String sstr = "";
        HashMap<String, List<Integer>> align_info = new HashMap<String, List<Integer>>();
        ArrayList<Integer> shift_dists = new ArrayList<Integer>();
        int anum = 1;
        int ind_start = 0;
        int ind_end = 1;
        int ind_from = 2;
        int ind_in = 3;
        int slen = 0;
        int non_inserr = 0;
        if (allshifts != null) {
            for (int i = 0; i < allshifts.length; ++i) {
                ArrayList<Integer> al;
                List<Object> val;
                int dist;
                int nfrom;
                int nend;
                int nstart;
                int ostart = allshifts[i].start;
                int oend = allshifts[i].end;
                int odest = allshifts[i].newloc;
                slen = allshifts[i].size();
                if (odest >= oend) {
                    nstart = odest + 1 - slen;
                    nend = nstart + slen - 1;
                    nfrom = ostart;
                    dist = odest - oend;
                } else {
                    nstart = odest + 1;
                    nend = nstart + slen - 1;
                    nfrom = ostart + slen;
                    dist = (ostart - odest - 1) * -1;
                }
                shift_dists.add(dist);
                if (anum > 1) {
                    AlignmentStringUtils.performShiftArray(align_info, ostart, oend, odest, alignment.length);
                }
                if ((val = align_info.get(nstart + "-" + ind_start)) == null) {
                    al = new ArrayList<Integer>();
                    al.add(anum);
                    align_info.put(nstart + "-" + ind_start, al);
                } else {
                    al = val;
                    al.add(anum);
                }
                val = align_info.get(nend + "-" + ind_end);
                if (val == null) {
                    al = new ArrayList<Integer>();
                    al.add(anum);
                    align_info.put(nend + "-" + ind_end, al);
                } else {
                    al = (ArrayList<Integer>)val;
                    al.add(anum);
                }
                val = align_info.get(nfrom + "-" + ind_from);
                if (val == null) {
                    al = new ArrayList();
                    al.add(anum);
                    align_info.put(nfrom + "-" + ind_from, al);
                } else {
                    al = val;
                    al.add(anum);
                }
                if (slen > 0) {
                    for (int j = nstart; j <= nend; ++j) {
                        List<Object> al2;
                        val = align_info.get(j + "-" + ind_in);
                        if (val == null) {
                            al2 = new ArrayList();
                            ((ArrayList)al2).add(anum);
                            align_info.put(j + "-" + ind_in, al2);
                            continue;
                        }
                        al2 = val;
                        ((ArrayList)al2).add(anum);
                    }
                }
                ++anum;
            }
        }
        int hyp_idx = 0;
        int ref_idx = 0;
        if (alignment != null) {
            for (int i = 0; i < alignment.length; ++i) {
                List val;
                int k;
                String s;
                int j;
                List<Integer> list;
                String shift_in_str = "";
                String ref_wd = ref_idx < ref.length ? String.valueOf(ref[ref_idx]) : "";
                String hyp_wd = hyp_idx < hyp.length ? String.valueOf(aftershift[hyp_idx]) : "";
                int l = 0;
                if (alignment[i] != 'D') {
                    List<Integer> val2 = (List<Integer>)align_info.get(hyp_idx + "-" + ind_from);
                    if (val2 != null) {
                        list = val2;
                        for (j = 0; j < list.size(); ++j) {
                            s = "" + list.get(j);
                            hstr = hstr + " @";
                            rstr = rstr + "  ";
                            estr = estr + "  ";
                            sstr = sstr + " " + s;
                            for (k = 1; k < s.length(); ++k) {
                                hstr = hstr + " ";
                                rstr = rstr + " ";
                                estr = estr + " ";
                            }
                        }
                    }
                    if ((val2 = (List)align_info.get(hyp_idx + "-" + ind_start)) != null) {
                        list = val2;
                        for (j = 0; j < list.size(); ++j) {
                            s = "" + list.get(j);
                            hstr = hstr + " [";
                            rstr = rstr + "  ";
                            estr = estr + "  ";
                            sstr = sstr + " " + s;
                            for (k = 1; k < s.length(); ++k) {
                                hstr = hstr + " ";
                                rstr = rstr + " ";
                                estr = estr + " ";
                            }
                        }
                    }
                    if (slen > 0 && (val2 = align_info.get(hyp_idx + "-" + ind_in)) != null) {
                        shift_in_str = SgmlProcessor.join(",", (ArrayList)val2);
                    }
                }
                switch (alignment[i]) {
                    case ' ': {
                        l = Math.max(ref_wd.length(), hyp_wd.length());
                        hstr = hstr + " " + hyp_wd;
                        rstr = rstr + " " + ref_wd;
                        estr = estr + " ";
                        sstr = sstr + " ";
                        for (int j2 = 0; j2 < l; ++j2) {
                            if (hyp_wd.length() <= j2) {
                                hstr = hstr + " ";
                            }
                            if (ref_wd.length() <= j2) {
                                rstr = rstr + " ";
                            }
                            estr = estr + " ";
                            sstr = sstr + " ";
                        }
                        ++hyp_idx;
                        ++ref_idx;
                        ++non_inserr;
                        break;
                    }
                    case 'S': 
                    case 'T': {
                        l = Math.max(ref_wd.length(), Math.max(hyp_wd.length(), Math.max(1, shift_in_str.length())));
                        hstr = hstr + " " + hyp_wd;
                        rstr = rstr + " " + ref_wd;
                        if (hyp_wd.equals("") || ref_wd.equals("")) {
                            System.out.println("unexpected empty");
                        }
                        estr = estr + " " + alignment[i];
                        sstr = sstr + " " + shift_in_str;
                        for (int j3 = 0; j3 < l; ++j3) {
                            if (hyp_wd.length() <= j3) {
                                hstr = hstr + " ";
                            }
                            if (ref_wd.length() <= j3) {
                                rstr = rstr + " ";
                            }
                            if (j3 > 0) {
                                estr = estr + " ";
                            }
                            if (j3 < shift_in_str.length()) continue;
                            sstr = sstr + " ";
                        }
                        ++ref_idx;
                        ++hyp_idx;
                        ++non_inserr;
                        break;
                    }
                    case 'D': {
                        l = ref_wd.length();
                        hstr = hstr + " ";
                        rstr = rstr + " " + ref_wd;
                        estr = estr + " D";
                        sstr = sstr + " ";
                        for (int j4 = 0; j4 < l; ++j4) {
                            hstr = hstr + "*";
                            if (j4 > 0) {
                                estr = estr + " ";
                            }
                            sstr = sstr + " ";
                        }
                        ++ref_idx;
                        ++non_inserr;
                        break;
                    }
                    case 'I': {
                        l = Math.max(hyp_wd.length(), shift_in_str.length());
                        hstr = hstr + " " + hyp_wd;
                        rstr = rstr + " ";
                        estr = estr + " I";
                        sstr = sstr + " " + shift_in_str;
                        for (int j5 = 0; j5 < l; ++j5) {
                            rstr = rstr + "*";
                            if (j5 >= hyp_wd.length()) {
                                hstr = hstr + " ";
                            }
                            if (j5 > 0) {
                                estr = estr + " ";
                            }
                            if (j5 < shift_in_str.length()) continue;
                            sstr = sstr + " ";
                        }
                        ++hyp_idx;
                    }
                }
                if (alignment[i] == 'D' || (val = (List)align_info.get(hyp_idx - 1 + "-" + ind_end)) == null) continue;
                list = val;
                for (j = 0; j < list.size(); ++j) {
                    s = "" + list.get(j);
                    hstr = hstr + " ]";
                    rstr = rstr + "  ";
                    estr = estr + "  ";
                    sstr = sstr + " " + s;
                    for (k = 1; k < s.length(); ++k) {
                        hstr = hstr + " ";
                        rstr = rstr + " ";
                        estr = estr + " ";
                    }
                }
            }
        }
        String indent = "";
        if (shiftonly) {
            indent = " ";
        }
        to_return = to_return + "\n" + indent + "REF: " + rstr;
        to_return = to_return + "\n" + indent + "HYP: " + hstr;
        if (!shiftonly) {
            to_return = to_return + "\n" + indent + "EVAL:" + estr;
            to_return = to_return + "\n" + indent + "SHFT:" + sstr;
        }
        to_return = to_return + "\n";
        return to_return;
    }

    public static void performShiftArray(HashMap<String, List<Integer>> hwords, int start, int end, int moveto, int capacity) {
        HashMap<String, List<Integer>> nhwords = new HashMap<String, List<Integer>>();
        if (moveto == -1) {
            AlignmentStringUtils.copyHashWords(hwords, nhwords, start, end, 0);
            AlignmentStringUtils.copyHashWords(hwords, nhwords, 0, start - 1, end - start + 1);
            AlignmentStringUtils.copyHashWords(hwords, nhwords, end + 1, capacity, end + 1);
        } else if (moveto < start) {
            AlignmentStringUtils.copyHashWords(hwords, nhwords, 0, moveto, 0);
            AlignmentStringUtils.copyHashWords(hwords, nhwords, start, end, moveto + 1);
            AlignmentStringUtils.copyHashWords(hwords, nhwords, moveto + 1, start - 1, end - start + moveto + 2);
            AlignmentStringUtils.copyHashWords(hwords, nhwords, end + 1, capacity, end + 1);
        } else if (moveto > end) {
            AlignmentStringUtils.copyHashWords(hwords, nhwords, 0, start - 1, 0);
            AlignmentStringUtils.copyHashWords(hwords, nhwords, end + 1, moveto, start);
            AlignmentStringUtils.copyHashWords(hwords, nhwords, start, end, start + moveto - end);
            AlignmentStringUtils.copyHashWords(hwords, nhwords, moveto + 1, capacity, moveto + 1);
        } else {
            AlignmentStringUtils.copyHashWords(hwords, nhwords, 0, start - 1, 0);
            AlignmentStringUtils.copyHashWords(hwords, nhwords, end + 1, end + moveto - start, start);
            AlignmentStringUtils.copyHashWords(hwords, nhwords, start, end, moveto);
            AlignmentStringUtils.copyHashWords(hwords, nhwords, end + moveto - start + 1, capacity, end + moveto - start + 1);
        }
        hwords.clear();
        hwords.putAll(nhwords);
    }

    static void copyHashWords(HashMap<String, List<Integer>> ohwords, HashMap<String, List<Integer>> nhwords, int start, int end, int nstart) {
        int ind_start = 0;
        boolean ind_end = true;
        int ind_from = 2;
        int ind_in = 3;
        int k = nstart;
        for (int i = start; i <= end; ++i) {
            for (int j = ind_start; j <= ind_in; ++j) {
                List<Integer> val = ohwords.get(i + "-" + j);
                if (val == null) continue;
                nhwords.put(k + "-" + j, val);
            }
            ++k;
        }
    }
}

