export GLUE_DIR="data/Amazon_few_shot"
mark=exp0
algo_type="MAML"
bert_model_path=outputs/$mark/

seed=42
memory_dir=saved_memory/$mark

cache_dir=model_cache/$mark
out=outputs/$mark/
tblog=tensorboard/$mark

mkdir -p $out $cache_dir $memory_dir $tblog

python main.py \
  --task_name Amazon \
  --cache_dir $cache_dir \
  --is_init= \
  --do_train=true \
  --do_eval \
  --do_lower_case \
  --data_dir $GLUE_DIR \
  --bert_model $bert_model_path \
  --max_seq_length 128 \
  --output_dir $out \
  --algo_type $algo_type \
  --neighbor_num=20 \
  --ratio=0.2 \
  --store_ratio=0.8 \
  --memory_dir=$memory_dir \
  --inner_learning_rate=2e-5 \
  --outer_learning_rate=1e-5 \
  --N_query=1 \
  --refresh_steps=300 \
  --all_task=true \
  --self_neighbor_ratio=0.2 \
  --save_tb=$tblog \
  --adapt_num=5 \
  --seed=$seed \
  >> logs/$mark.log 2>> logs/$mark.err