/*
 * Decompiled with CFR 0.152.
 */
package se.liu.ida.nlp.sdp.toolkit.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import se.liu.ida.nlp.sdp.toolkit.graph.Graph;
import se.liu.ida.nlp.sdp.toolkit.graph.Node;
import se.liu.ida.nlp.sdp.toolkit.io.GraphReader;
import se.liu.ida.nlp.sdp.toolkit.io.ParagraphReader;

public class GraphReader2015
extends ParagraphReader
implements GraphReader {
    public GraphReader2015(Reader reader) {
        super(reader);
        this.readFirstLine();
    }

    public GraphReader2015(File file) throws FileNotFoundException {
        super(file);
        this.readFirstLine();
    }

    public GraphReader2015(String fileName) throws FileNotFoundException {
        super(fileName);
        this.readFirstLine();
    }

    private void readFirstLine() {
        try {
            String line = super.readLine();
            assert (line.equals("#SDP 2015"));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Graph readGraph() throws IOException {
        List<String> lines = super.readParagraph();
        if (lines == null) {
            return null;
        }
        assert (lines.size() >= 2);
        assert (lines.get(0).matches("#2[0-9]{7}$"));
        Graph graph = new Graph(lines.get(0));
        graph.addNode("$$_FORM", "$$_LEMMA", "$$_POS", false, false, "$$_SENSE");
        ArrayList<Integer> predicates = new ArrayList<Integer>();
        for (String line : lines.subList(1, lines.size())) {
            String[] tokens = line.split("\t");
            assert (tokens.length >= 7);
            assert (tokens[4].equals("+") || tokens[4].equals("-"));
            assert (tokens[5].equals("+") || tokens[5].equals("-"));
            String form = tokens[1];
            String lemma = tokens[2];
            String pos = tokens[3];
            boolean isTop = tokens[4].equals("+");
            boolean isPred = tokens[5].equals("+");
            String sense = tokens[6];
            Node node = graph.addNode(form, lemma, pos, isTop, isPred, sense);
            assert (node.id == Integer.parseInt(tokens[0]));
            if (!node.isPred) continue;
            predicates.add(node.id);
        }
        int id = 1;
        for (String line : lines.subList(1, lines.size())) {
            String[] tokens = line.split("\t");
            assert (tokens.length == 7 + predicates.size());
            for (int i = 7; i < tokens.length; ++i) {
                if (tokens[i].equals("_")) continue;
                graph.addEdge((Integer)predicates.get(i - 7), id, tokens[i]);
            }
            ++id;
        }
        for (Node node : graph.getNodes()) {
            assert (!node.isPred || node.hasOutgoingEdges());
        }
        return graph;
    }
}

