/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.pear.dag;

import edu.pku.coli.io.DAGSentenceReader;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import fig.exec.Execution;
import java.io.File;
import java.util.Iterator;
import java.util.Set;

public class Evaluator
implements Runnable {
    @Option(gloss="Training file in CCGBank's PARG format")
    public transient String goldPARG = null;
    @Option(gloss="Training file in CoNLL format", required=true)
    public transient String goldCoNLL = null;
    @Option(gloss="Development file in CCGBank's PARG format")
    public transient String sysPARG = null;
    @Option(gloss="Development file in CoNLL format", required=true)
    public transient String sysCoNLL = null;
    @Option(gloss="Unlabel? default = false")
    public boolean unlab = false;
    @Option(gloss="Data format (CONLL06 | CONLL08 | CCGBANK | XML | SDP) default = CONLL08")
    public String dataFormat = "CONLL08";
    @Option(gloss="Read data as tree? default = false")
    public boolean asTree = false;
    double number_of_predicted_pairs;
    double number_of_gold_pairs;
    double number_of_correct_unlabeled_pairs;
    double number_of_correct_labeled_pairs;
    double number_of_correct_typed_pairs;
    double number_of_graph;
    double number_of_correct_unlabeled_graph;
    double number_of_correct_labeled_graph;
    double number_of_correct_typed_graph;
    double number_of_correct_types;
    double number_of_types;
    double number_of_unrooted_predicted_pairs;
    double number_of_unrooted_gold_pairs;
    double number_of_unrooted_correct_unlabeled_pairs;
    double number_of_unrooted_correct_labeled_pairs;
    double number_of_unrooted_correct_typed_pairs;
    double number_of_unrooted_correct_unlabeled_graph;
    double number_of_unrooted_correct_labeled_graph;
    double number_of_unrooted_correct_typed_graph;

    private Iterable<SentenceForDAGParsing> readSentenceForDAGParsing(String pargFile, String conllFile) {
        if (this.asTree) {
            if (this.dataFormat.equalsIgnoreCase("CONLL06")) {
                return DAGSentenceReader.treesReaderFromCoNLL06(conllFile);
            }
            if (this.dataFormat.equalsIgnoreCase("CONLL08")) {
                return DAGSentenceReader.treesReaderFromCoNLL08(conllFile);
            }
        } else {
            if (this.dataFormat.equalsIgnoreCase("CONLL06")) {
                return DAGSentenceReader.dagsReaderFromPARGwithCoNLL06(pargFile, conllFile, false);
            }
            if (this.dataFormat.equalsIgnoreCase("CONLL08")) {
                return DAGSentenceReader.dagsReaderFromCoNLL08(conllFile, false);
            }
            if (this.dataFormat.equalsIgnoreCase("CCGBANK")) {
                return DAGSentenceReader.dagsReaderFromPARGwithCCGBank(new File(pargFile), new File(conllFile));
            }
            if (this.dataFormat.equalsIgnoreCase("STANFORD")) {
                return DAGSentenceReader.dagsReaderFromStanfordFormatWithCoNLL06(pargFile, conllFile, false);
            }
            if (this.dataFormat.equalsIgnoreCase("XML")) {
                return DAGSentenceReader.dagsReaderFromXML(new File(conllFile), false);
            }
            if (this.dataFormat.equalsIgnoreCase("SDP")) {
                return DAGSentenceReader.dagsReaderFromSDP(conllFile);
            }
            if (this.dataFormat.equalsIgnoreCase("SDP15")) {
                return DAGSentenceReader.dagsReaderFromSDP15(conllFile);
            }
        }
        return null;
    }

    public void registry(PredicateArgumentAdjunctDAG gold, PredicateArgumentAdjunctDAG sys) {
        this.number_of_graph += 1.0;
        this.registry(gold, sys, true);
        this.registry(gold, sys, false);
        if (sys.isTyped()) {
            int numTypes = 0;
            int numCorrectTypes = 0;
            numTypes = gold._types.size() - 1;
            int i = 1;
            while (i < gold._types.size()) {
                if (sys._types.size() > i && gold._types.get(i).equals(sys._types.get(i))) {
                    ++numCorrectTypes;
                }
                ++i;
            }
            this.number_of_types += (double)numTypes;
            this.number_of_correct_types += (double)numCorrectTypes;
        }
    }

    public void registry(PredicateArgumentAdjunctDAG gold, PredicateArgumentAdjunctDAG sys, boolean excludeRoot) {
        if (gold == null) {
            return;
        }
        int gold_pairs = 0;
        int predicted_pairs = 0;
        int correct_unlabeled_pairs = 0;
        int correct_labeled_pairs = 0;
        int correct_typed_pairs = 0;
        int correct_typed_graph = 0;
        int correct_unlabeled_graph = 0;
        int correct_labeled_graph = 0;
        if (sys == null) {
            gold_pairs += gold.toUnlabeledPairs(excludeRoot).size();
        } else {
            Set<Pair<Integer, Integer>> goldUnlabeledPairs = gold.toUnlabeledPairs(excludeRoot);
            int goldPair = goldUnlabeledPairs.size();
            Set<Pair<Integer, Integer>> sysUnlabeledPairs = sys.toUnlabeledPairs(excludeRoot);
            int sysPair = sysUnlabeledPairs.size();
            goldUnlabeledPairs.retainAll(sysUnlabeledPairs);
            int correctUnlabeled = goldUnlabeledPairs.size();
            Set<Pair<Pair<Integer, Integer>, String>> goldLabeledPairs = gold.toLabeledPairs(excludeRoot);
            Set<Pair<Pair<Integer, Integer>, String>> sysLabeledPairs = sys.toLabeledPairs(excludeRoot);
            goldLabeledPairs.retainAll(sysLabeledPairs);
            int correctLabeled = goldLabeledPairs.size();
            gold_pairs += goldPair;
            predicted_pairs += sysPair;
            correct_unlabeled_pairs += correctUnlabeled;
            correct_labeled_pairs += correctLabeled;
            if (sys.isTyped()) {
                Set<Pair<Pair<Pair<Integer, Integer>, String>, String>> goldTypedPairs = gold.toTypedPairs(excludeRoot);
                Set<Pair<Pair<Pair<Integer, Integer>, String>, String>> sysTypedPairs = sys.toTypedPairs(excludeRoot);
                goldTypedPairs.retainAll(sysTypedPairs);
                int correctTyped = goldTypedPairs.size();
                correct_typed_pairs += correctTyped;
                if (correctTyped == sysPair && correctTyped == goldPair) {
                    ++correct_typed_graph;
                }
            }
            if (correctUnlabeled == sysPair && correctUnlabeled == goldPair) {
                ++correct_unlabeled_graph;
            }
            if (correctLabeled == sysPair && correctLabeled == goldPair) {
                ++correct_labeled_graph;
            }
        }
        if (excludeRoot) {
            this.number_of_unrooted_predicted_pairs += (double)predicted_pairs;
            this.number_of_unrooted_gold_pairs += (double)gold_pairs;
            this.number_of_unrooted_correct_unlabeled_pairs += (double)correct_unlabeled_pairs;
            this.number_of_unrooted_correct_labeled_pairs += (double)correct_labeled_pairs;
            this.number_of_unrooted_correct_typed_pairs += (double)correct_typed_pairs;
            this.number_of_unrooted_correct_unlabeled_graph += (double)correct_unlabeled_graph;
            this.number_of_unrooted_correct_labeled_graph += (double)correct_labeled_graph;
            this.number_of_unrooted_correct_typed_graph += (double)correct_typed_graph;
        } else {
            this.number_of_predicted_pairs += (double)predicted_pairs;
            this.number_of_gold_pairs += (double)gold_pairs;
            this.number_of_correct_unlabeled_pairs += (double)correct_unlabeled_pairs;
            this.number_of_correct_labeled_pairs += (double)correct_labeled_pairs;
            this.number_of_correct_typed_pairs += (double)correct_typed_pairs;
            this.number_of_correct_unlabeled_graph += (double)correct_unlabeled_graph;
            this.number_of_correct_labeled_graph += (double)correct_labeled_graph;
            this.number_of_correct_typed_graph += (double)correct_typed_graph;
        }
    }

    public double unlabeledRecallExcludeRoot() {
        return this.number_of_unrooted_correct_unlabeled_pairs / this.number_of_unrooted_gold_pairs * 100.0;
    }

    public double unlabeledPrecisionExcludeRoot() {
        return this.number_of_unrooted_correct_unlabeled_pairs / this.number_of_unrooted_predicted_pairs * 100.0;
    }

    public double unlabeledFscoreExcludeRoot() {
        double r = this.unlabeledRecallExcludeRoot();
        double p = this.unlabeledPrecisionExcludeRoot();
        return 2.0 * r * p / (r + p);
    }

    public double labeledRecallExcludeRoot() {
        return this.number_of_unrooted_correct_labeled_pairs / this.number_of_unrooted_gold_pairs * 100.0;
    }

    public double labeledPrecisionExcludeRoot() {
        return this.number_of_unrooted_correct_labeled_pairs / this.number_of_unrooted_predicted_pairs * 100.0;
    }

    public double labeledFscoreExcludeRoot() {
        double r = this.labeledRecallExcludeRoot();
        double p = this.labeledPrecisionExcludeRoot();
        return 2.0 * r * p / (r + p);
    }

    public double typedRecallExcludeRoot() {
        return this.number_of_unrooted_correct_typed_pairs / this.number_of_unrooted_gold_pairs * 100.0;
    }

    public double typedPrecisionExcludeRoot() {
        return this.number_of_unrooted_correct_typed_pairs / this.number_of_unrooted_predicted_pairs * 100.0;
    }

    public double typedFscoreExcludeRoot() {
        double r = this.typedRecallExcludeRoot();
        double p = this.typedPrecisionExcludeRoot();
        return 2.0 * r * p / (r + p);
    }

    public double unlabeledCompleteScoreExcludeRoot() {
        return this.number_of_unrooted_correct_unlabeled_graph / this.number_of_graph * 100.0;
    }

    public double labeledCompleteScoreExcludeRoot() {
        return this.number_of_unrooted_correct_labeled_graph / this.number_of_graph * 100.0;
    }

    public double typedCompleteScoreExcludeRoot() {
        return this.number_of_unrooted_correct_typed_graph / this.number_of_graph * 100.0;
    }

    public double unlabeledRecall() {
        return this.number_of_correct_unlabeled_pairs / this.number_of_gold_pairs * 100.0;
    }

    public double unlabeledPrecision() {
        return this.number_of_correct_unlabeled_pairs / this.number_of_predicted_pairs * 100.0;
    }

    public double unlabeledFscore() {
        double r = this.unlabeledRecall();
        double p = this.unlabeledPrecision();
        return 2.0 * r * p / (r + p);
    }

    public double labeledRecall() {
        return this.number_of_correct_labeled_pairs / this.number_of_gold_pairs * 100.0;
    }

    public double labeledPrecision() {
        return this.number_of_correct_labeled_pairs / this.number_of_predicted_pairs * 100.0;
    }

    public double labeledFscore() {
        double r = this.labeledRecall();
        double p = this.labeledPrecision();
        return 2.0 * r * p / (r + p);
    }

    public double typedRecall() {
        return this.number_of_correct_typed_pairs / this.number_of_gold_pairs * 100.0;
    }

    public double typedPrecision() {
        return this.number_of_correct_typed_pairs / this.number_of_predicted_pairs * 100.0;
    }

    public double typedFscore() {
        double r = this.typedRecall();
        double p = this.typedPrecision();
        return 2.0 * r * p / (r + p);
    }

    public double typeTaggingAccuracy() {
        return this.number_of_correct_types / this.number_of_types * 100.0;
    }

    public double unlabeledCompleteScore() {
        return this.number_of_correct_unlabeled_graph / this.number_of_graph * 100.0;
    }

    public double labeledCompleteScore() {
        return this.number_of_correct_labeled_graph / this.number_of_graph * 100.0;
    }

    public double typedCompleteScore() {
        return this.number_of_correct_typed_graph / this.number_of_graph * 100.0;
    }

    public static Evaluator evaluateOnePair(PredicateArgumentAdjunctDAG gold, PredicateArgumentAdjunctDAG sys) {
        Evaluator e = new Evaluator();
        e.registry(gold, sys);
        return e;
    }

    public String toString() {
        String ret = "Scores including root:\n";
        ret = String.valueOf(ret) + String.format("UP : UR : UF : UCompl = %.2f : %.2f : %.2f : %.2f\n", this.unlabeledPrecision(), this.unlabeledRecall(), this.unlabeledFscore(), this.unlabeledCompleteScore());
        ret = String.valueOf(ret) + String.format("LP : LR : LF :LCompl = %.2f : %.2f : %.2f : %.2f\n", this.labeledPrecision(), this.labeledRecall(), this.labeledFscore(), this.labeledCompleteScore());
        if (this.number_of_correct_types > 0.0) {
            ret = String.valueOf(ret) + String.format("TP : TR : TF : TA : TCompl = %.2f : %.2f : %.2f : %.2f : %.2f\n", this.typedPrecision(), this.typedRecall(), this.typedFscore(), this.typeTaggingAccuracy(), this.typedCompleteScore());
        }
        ret = String.valueOf(ret) + "Scores excluding root:\n";
        ret = String.valueOf(ret) + String.format("UP : UR : UF : UCompl = %.2f : %.2f : %.2f : %.2f", this.unlabeledPrecisionExcludeRoot(), this.unlabeledRecallExcludeRoot(), this.unlabeledFscoreExcludeRoot(), this.unlabeledCompleteScoreExcludeRoot());
        ret = String.valueOf(ret) + "\n" + String.format("LP : LR : LF :LCompl = %.2f : %.2f : %.2f : %.2f", this.labeledPrecisionExcludeRoot(), this.labeledRecallExcludeRoot(), this.labeledFscoreExcludeRoot(), this.labeledCompleteScoreExcludeRoot());
        if (this.number_of_correct_types > 0.0) {
            ret = String.valueOf(ret) + "\n" + String.format("TP : TR : TF : TA : TCompl = %.2f : %.2f : %.2f : %.2f : %.2f", this.typedPrecisionExcludeRoot(), this.typedRecallExcludeRoot(), this.typedFscoreExcludeRoot(), this.typeTaggingAccuracy(), this.typedCompleteScoreExcludeRoot());
        }
        return ret;
    }

    @Override
    public void run() {
        PredicateArgumentAdjunctDAG.CONLL08_TYPE_COL = 7;
        System.out.println("Evaluating " + this.goldCoNLL + " : " + this.sysCoNLL);
        Iterable<SentenceForDAGParsing> golds = this.readSentenceForDAGParsing(this.goldPARG, this.goldCoNLL);
        Iterable<SentenceForDAGParsing> syss = this.readSentenceForDAGParsing(this.sysPARG, this.sysCoNLL);
        Iterator<SentenceForDAGParsing> sysIter = syss.iterator();
        for (SentenceForDAGParsing goldSent : golds) {
            PredicateArgumentAdjunctDAG gold = goldSent.getGoldDAG();
            if (!sysIter.hasNext()) break;
            PredicateArgumentAdjunctDAG sys = sysIter.next().getGoldDAG();
            this.registry(gold, sys);
        }
        LogInfo.logs(this);
    }

    public static void main(String[] args) {
        Execution.run(args, new Evaluator());
    }
}

