/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.dualdecomp;

import edu.pku.coli.dualdecomp.AbstractDecoder;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ArgumentCentricDecoder
extends AbstractDecoder {
    private static final long serialVersionUID = -2734022815604927545L;
    int[] maxPosPred;
    boolean[][] posArcFilter;
    transient double[][][] scores;

    public ArgumentCentricDecoder() {
        this.featureExtractor = new FeatureExtractor();
    }

    @Override
    public void train(List<SentenceForDAGParsing> trainset, List<SentenceForDAGParsing> devset) {
        this.maxPosPred = new int[SentenceForDAGParsing.posIndexer.size()];
        this.posArcFilter = new boolean[SentenceForDAGParsing.posIndexer.size()][SentenceForDAGParsing.posIndexer.size()];
        if (this.prune) {
            for (SentenceForDAGParsing s : trainset) {
                PredicateArgumentAdjunctDAG dag = s.getGoldDAG();
                int i = 1;
                while (i <= s.numOfWords()) {
                    List<PredicateArgumentAdjunctDAG.ArcInfo> arcs;
                    int numOfPred;
                    int posi = s.getKthPosIndex(i);
                    if (this.maxPosPred[posi] < (numOfPred = (arcs = dag.getAdjacencyLists()[i].getInArcs()).size())) {
                        this.maxPosPred[posi] = numOfPred;
                    }
                    for (PredicateArgumentAdjunctDAG.ArcInfo arc : arcs) {
                        int posj = s.getKthPosIndex(arc.index);
                        this.posArcFilter[posj][posi] = true;
                    }
                    ++i;
                }
            }
        } else {
            Arrays.fill(this.maxPosPred, Integer.MAX_VALUE);
            int i = 0;
            while (i < this.posArcFilter.length) {
                int j = 0;
                while (j < this.posArcFilter[i].length) {
                    this.posArcFilter[i][j] = true;
                    ++j;
                }
                ++i;
            }
        }
        System.out.println(Arrays.toString(this.maxPosPred));
        int i = 0;
        while (i < this.posArcFilter.length) {
            System.out.println(Arrays.toString(this.posArcFilter[i]));
            ++i;
        }
        super.train(trainset, devset);
    }

    @Override
    public SentenceForDAGParsing toDAGSentence(SentenceForDAGParsing sent, int[][] var) {
        int sentLen = sent.numOfWords();
        PredicateArgumentAdjunctDAG sys = new PredicateArgumentAdjunctDAG(sentLen);
        int i = 0;
        while (i <= sentLen) {
            int j = 0;
            while (j <= sentLen) {
                if (var[i][j] == 1) {
                    sys.addArc(i, j, "X");
                }
                ++j;
            }
            ++i;
        }
        sent.setPredictedDAG(sys);
        return sent;
    }

    @Override
    public int[][] toVariable(SentenceForDAGParsing sent) {
        int sentLen = sent.numOfWords();
        int[][] var = new int[sentLen + 1][sentLen + 1];
        PredicateArgumentAdjunctDAG dag = sent.getGoldDAG();
        for (Pair<Integer, Integer> arc : dag.toUnlabeledPairs()) {
            var[arc.getFirst().intValue()][arc.getSecond().intValue()] = 1;
        }
        return var;
    }

    @Override
    public int[][] decodeAfterScoring(double[][] additionalWeight) {
        SentenceForDAGParsing sent = this.curSent;
        int sentLen = sent.numOfWords();
        double totalScore = 0.0;
        int[][] var = new int[sentLen + 1][sentLen + 1];
        int i = 1;
        while (i <= sentLen) {
            int posi = sent.getKthPosIndex(i);
            double[][] scoresi = new double[sentLen + 2][];
            int j = 0;
            while (j < sentLen + 2) {
                scoresi[j] = Arrays.copyOf(this.scores[i - 1][j], sentLen + 2);
                int k = j;
                while (k <= sentLen) {
                    double[] dArray = scoresi[j];
                    int n = k;
                    dArray[n] = dArray[n] + additionalWeight[k][i];
                    ++k;
                }
                ++j;
            }
            int maxNumOfPred = Math.min(sentLen - 1, this.maxPosPred[posi]);
            double[][] table = new double[maxNumOfPred + 1][sentLen + 2];
            int[][] bp = new int[maxNumOfPred + 1][sentLen + 2];
            int k = 0;
            while (k < sentLen + 2) {
                table[0][k] = scoresi[0][k];
                ++k;
            }
            int j2 = 1;
            while (j2 <= maxNumOfPred) {
                int k2 = j2;
                while (k2 < sentLen + 2) {
                    double max = Double.NEGATIVE_INFINITY;
                    int l = j2 - 1;
                    while (l < k2) {
                        double s = table[j2 - 1][l] + scoresi[l + 1][k2];
                        if (s >= max) {
                            max = s;
                            bp[j2][k2] = l;
                        }
                        ++l;
                    }
                    table[j2][k2] = max;
                    ++k2;
                }
                ++j2;
            }
            double maxScore = Double.NEGATIVE_INFINITY;
            int nPredicate = -1;
            int j3 = 0;
            while (j3 <= maxNumOfPred) {
                if (table[j3][sentLen + 1] >= maxScore) {
                    nPredicate = j3;
                    maxScore = table[j3][sentLen + 1];
                }
                ++j3;
            }
            int last = bp[nPredicate][sentLen + 1];
            if (nPredicate != 0) {
                var[last][i] = 1;
                int j4 = nPredicate - 1;
                while (j4 > 0) {
                    last = bp[j4][last];
                    var[last][i] = 1;
                    --j4;
                }
            }
            totalScore += maxScore;
            ++i;
        }
        return var;
    }

    @Override
    public void scoreFeats(final float[] param) {
        final SentenceForDAGParsing sent = this.curSent;
        final FeatureExtractor fe = (FeatureExtractor)this.featureExtractor;
        int sentLen = sent.numOfWords();
        this.scores = new double[sentLen][sentLen + 2][sentLen + 2];
        int i = 1;
        while (i <= sentLen) {
            int k;
            int posi = sent.getKthPosIndex(i);
            double[][] scoresi = this.scores[i - 1];
            ExecutorService es = Executors.newFixedThreadPool(this.threadNum);
            ExecutorCompletionService<Double> group = new ExecutorCompletionService<Double>(es);
            Future[][] results = new Future[sentLen + 2][sentLen + 2];
            int j = 0;
            while (j < sentLen + 2) {
                k = j;
                while (k < sentLen + 2) {
                    block15: {
                        block14: {
                            if (this.posArcFilter == null || j == 0 || k == sentLen + 1) break block14;
                            int posj = sent.getKthPosIndex(j - 1);
                            int posk = sent.getKthPosIndex(k);
                            if (!this.posArcFilter[posj][posi] || !this.posArcFilter[posk][posi]) break block15;
                        }
                        final int fi = i;
                        final int fj = j;
                        final int fk = k;
                        results[j][k] = group.submit(new Callable<Double>(){

                            @Override
                            public Double call() {
                                return fe.scoreParents(fi, fj - 1, fk, sent, param);
                            }
                        });
                    }
                    ++k;
                }
                ++j;
            }
            es.shutdown();
            j = 0;
            while (j < sentLen + 2) {
                k = j;
                while (k < sentLen + 2) {
                    if (results[j][k] == null) {
                        scoresi[j][k] = Double.NEGATIVE_INFINITY;
                    } else {
                        try {
                            scoresi[j][k] = (Double)results[j][k].get();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        catch (ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    class FeatureExtractor
    extends AbstractDecoder.FeatureExtractor {
        private static final long serialVersionUID = 508661441088211477L;

        FeatureExtractor() {
        }

        @Override
        List<Integer> extract(SentenceForDAGParsing sent, boolean predicted) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int sentLen = sent.numOfWords();
            PredicateArgumentAdjunctDAG dag = sent.getGoldDAG();
            if (predicted) {
                dag = sent.getPredictedDAG();
            }
            int i = 1;
            while (i <= sentLen) {
                PredicateArgumentAdjunctDAG.PredicateArgumentAdjunctArcAdjacencyList arcs = dag.getAdjacencyLists()[i];
                List<PredicateArgumentAdjunctDAG.ArcInfo> inArcs = arcs.getInArcs();
                if (!inArcs.isEmpty()) {
                    ret.addAll(this.parentFeats(i, -1, inArcs.get((int)0).index, sent));
                    int j = 1;
                    while (j < inArcs.size()) {
                        ret.addAll(this.parentFeats(i, inArcs.get((int)(j - 1)).index, inArcs.get((int)j).index, sent));
                        ++j;
                    }
                    ret.addAll(this.parentFeats(i, inArcs.get((int)(inArcs.size() - 1)).index, sentLen + 1, sent));
                } else {
                    ret.addAll(this.parentFeats(i, -1, sentLen + 1, sent));
                }
                ++i;
            }
            return ret;
        }

        public List<Integer> parentFeats(int argument, int prev, int cur, SentenceForDAGParsing sent) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int n = 1024;
            int argumentWord = sent.getKthWordIndex(argument);
            int argumentPos = sent.getKthWordIndex(argument);
            int preArgumentWord = sent.getKthWordIndex(argument - 1);
            int postArgumentWord = sent.getKthWordIndex(argument + 1);
            int preArgumentPos = sent.getKthPosIndex(argument - 1);
            int postArgumentPos = sent.getKthPosIndex(argument + 1);
            int curWord = sent.getKthWordIndex(cur);
            int curPos = sent.getKthPosIndex(cur);
            int preCurWord = sent.getKthWordIndex(cur - 1);
            int postCurWord = sent.getKthWordIndex(cur + 1);
            int preCurPos = sent.getKthPosIndex(cur - 1);
            int postCurPos = sent.getKthPosIndex(cur + 1);
            int prevWord = sent.getKthWordIndex(prev);
            int prevPos = sent.getKthPosIndex(prev);
            int prePrevWord = sent.getKthWordIndex(prev - 1);
            int postPrevWord = sent.getKthWordIndex(prev + 1);
            int prePrevPos = sent.getKthPosIndex(prev - 1);
            int postPrevPos = sent.getKthPosIndex(prev + 1);
            int distCur = ArgumentCentricDecoder.this.distMap(argument - cur);
            int distCurPrev = ArgumentCentricDecoder.this.distMap(cur - prev);
            int distPrev = ArgumentCentricDecoder.this.distMap(argument - prev);
            int order = distCur > 0 ? 1 : (distPrev < 0 ? 2 : 3);
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, distCurPrev));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, distCurPrev));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, distCurPrev));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, preArgumentWord, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, preArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, preArgumentWord, preArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, preCurWord, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, preCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, preCurWord, preCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prePrevWord, distCurPrev));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prePrevPos, distCurPrev));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prePrevWord, prePrevPos, distCurPrev));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postArgumentWord, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postArgumentWord, postArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postCurWord, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postCurWord, postCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postPrevWord, distCurPrev));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postPrevPos, distCurPrev));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postPrevWord, postPrevPos, distCurPrev));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, preArgumentWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, preArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, preArgumentWord, preArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, preCurWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, preCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, preCurWord, preCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prePrevWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prePrevPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prePrevWord, prePrevPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postArgumentWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postArgumentWord, postArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postCurWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postCurWord, postCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postPrevWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postPrevPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, postPrevWord, postPrevPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, curWord, curPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, curWord, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, curPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, curWord, curPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, curWord, curPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, curWord, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, curPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, curWord, curPos, distCurPrev));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, curWord, distCurPrev));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, curPos, distCurPrev));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, curWord, curPos, distCurPrev));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, curWord, curPos, distCurPrev));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, curWord, distCurPrev));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, curPos, distCurPrev));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, curWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, curWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, curWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, curWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, curWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, curWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, preArgumentWord, preArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, preArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, preArgumentWord, preArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, preArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, postArgumentWord, postArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, postArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, postArgumentWord, postArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, postArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, preArgumentWord, preArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, preArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, preArgumentWord, preArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, preArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, postArgumentWord, postArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, postArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, postArgumentWord, postArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, postArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, preCurWord, preCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, preCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, preCurWord, preCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, preCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, postCurWord, postCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, postCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, postCurWord, postCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, postCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, preCurWord, preCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, preCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, preCurWord, preCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, preCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, postCurWord, postCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, postCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, postCurWord, postCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, postCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, preArgumentWord, preArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, preArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, preArgumentWord, preArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, preArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, postArgumentWord, postArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, postArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, postArgumentWord, postArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, postArgumentPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, preArgumentWord, preArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, preArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, preArgumentWord, preArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, preArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, postArgumentWord, postArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curWord, curPos, postArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, postArgumentWord, postArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, curPos, postArgumentPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, preCurWord, preCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, preCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, preCurWord, preCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, preCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, postCurWord, postCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, postCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, postCurWord, postCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, postCurPos, distCur));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, preCurWord, preCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, preCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, preCurWord, preCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, preCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, postCurWord, postCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, postCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, postCurWord, postCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, postCurPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, prevWord, prevPos, curWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, prevWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, prevWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, prevPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, prevPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, prevWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, prevWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, prevPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, prevPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, preCurWord, preCurPos, curWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, preCurWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, preCurWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, preCurPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, preCurPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, preCurWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, preCurWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, preCurPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, preCurPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, postCurWord, postCurPos, curWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, postCurWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, postCurWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, postCurPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, postCurPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, postCurWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, postCurWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, postCurPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, postCurPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, preArgumentWord, preArgumentPos, curWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, preArgumentWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, preArgumentWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, preArgumentPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, preArgumentPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, preArgumentWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, preArgumentWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, preArgumentPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, preArgumentPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, argumentPos, postArgumentWord, postArgumentPos, curWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, postArgumentWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, postArgumentWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, postArgumentPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentWord, postArgumentPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, postArgumentWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, postArgumentWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, postArgumentPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, argumentPos, postArgumentPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, preCurWord, preCurPos, curWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, preCurWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, preCurWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, preCurPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, preCurPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, preCurWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, preCurWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, preCurPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, preCurPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, postCurWord, postCurPos, curWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, postCurWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, postCurWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, postCurPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, postCurPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, postCurWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, postCurWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, postCurPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, postCurPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, prePrevWord, prePrevPos, curWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, prePrevWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, prePrevWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, prePrevPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, prePrevPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, prePrevWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, prePrevWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, prePrevPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, prePrevPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, prevPos, postPrevWord, postPrevPos, curWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, postPrevWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, postPrevWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, postPrevPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevWord, postPrevPos, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, postPrevWord, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, postPrevWord, curPos, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, postPrevPos, curWord, order));
            ret.add(ArgumentCentricDecoder.this.hashInts(n++, prevPos, postPrevPos, curPos, order));
            PredicateArgumentAdjunctDAG tree = sent.getSyntaxTree();
            if (ArgumentCentricDecoder.this.usePathFeat && tree != null && !tree.isEmpty() && cur <= sent.numOfWords()) {
                char p;
                int pos;
                PredicateArgumentAdjunctDAG.ArcInfo parentArc;
                ArrayList<Integer> curToRoot = new ArrayList<Integer>();
                ArrayList<Integer> dependentToRoot = new ArrayList<Integer>();
                int t = cur;
                while ((parentArc = tree.getOneParent(t)) != null) {
                    curToRoot.add(t);
                    t = parentArc.index;
                }
                curToRoot.add(t);
                t = argument;
                while ((parentArc = tree.getOneParent(t)) != null) {
                    dependentToRoot.add(t);
                    t = parentArc.index;
                }
                dependentToRoot.add(t);
                int leastCommonAncestor = 1;
                while (leastCommonAncestor <= curToRoot.size() && leastCommonAncestor <= dependentToRoot.size() && curToRoot.get(curToRoot.size() - leastCommonAncestor) == dependentToRoot.get(dependentToRoot.size() - leastCommonAncestor)) {
                    ++leastCommonAncestor;
                }
                int pathPoss = n++;
                int pathP = n++;
                int i = 0;
                while (i <= curToRoot.size() - leastCommonAncestor) {
                    pos = sent.getKthPosIndex((Integer)curToRoot.get(i));
                    p = sent.getKthPos((Integer)curToRoot.get(i)).charAt(0);
                    pathPoss = 31 * pathPoss + pos;
                    pathP = 31 * pathP + p;
                    ++i;
                }
                pathPoss = -pathPoss;
                pathP = -pathP;
                if (leastCommonAncestor > 1) {
                    int pos2 = sent.getKthPosIndex((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1));
                    char p2 = sent.getKthPos((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1)).charAt(0);
                    pathPoss = 31 * pathPoss + pos2;
                    pathPoss = 31 * pathPoss + SentenceForDAGParsing.posIndexer.size();
                    pathP = 31 * pathP + p2;
                    pathP = 31 * pathP + 255;
                }
                i = dependentToRoot.size() - leastCommonAncestor;
                while (i >= 0) {
                    pos = sent.getKthPosIndex((Integer)dependentToRoot.get(i));
                    p = sent.getKthPos((Integer)dependentToRoot.get(i)).charAt(0);
                    pathPoss = 31 * pathPoss + pos;
                    pathP = 31 * pathP + p;
                    --i;
                }
                ret.add(ArgumentCentricDecoder.this.hashInts(pathPoss));
                ret.add(ArgumentCentricDecoder.this.hashInts(pathP));
                ret.add(ArgumentCentricDecoder.this.hashInts(pathPoss, distCur));
                ret.add(ArgumentCentricDecoder.this.hashInts(pathP, distCur));
                ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathPoss, argumentWord, argumentPos, curWord, curPos, distCur));
                ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathPoss, argumentWord, argumentPos, curWord, distCur));
                ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathPoss, argumentWord, argumentPos, curPos, distCur));
                ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathPoss, argumentWord, curWord, curPos, distCur));
                ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathPoss, argumentPos, curWord, curPos, distCur));
                ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathPoss, argumentWord, curWord, distCur));
                ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathPoss, argumentPos, curPos, distCur));
                ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathP, argumentWord, argumentPos, curWord, curPos, distCur));
                ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathP, argumentWord, argumentPos, curWord, distCur));
                ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathP, argumentWord, argumentPos, curPos, distCur));
                ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathP, argumentWord, curWord, curPos, distCur));
                ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathP, argumentPos, curWord, curPos, distCur));
                ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathP, argumentWord, curWord, distCur));
                ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathP, argumentPos, curPos, distCur));
            }
            if (sent.getMoreSyntaxTrees() != null && cur <= sent.numOfWords()) {
                for (PredicateArgumentAdjunctDAG mtree : sent.getMoreSyntaxTrees()) {
                    char p;
                    int pos;
                    PredicateArgumentAdjunctDAG.ArcInfo parentArc;
                    ArrayList<Integer> curToRoot = new ArrayList<Integer>();
                    ArrayList<Integer> dependentToRoot = new ArrayList<Integer>();
                    ArrayList<String> stkTopToRootLabels = new ArrayList<String>();
                    ArrayList<String> queTopToRootLabels = new ArrayList<String>();
                    int t = cur;
                    while ((parentArc = mtree.getOneParent(t)) != null) {
                        curToRoot.add(t);
                        stkTopToRootLabels.add(parentArc.label);
                        t = parentArc.index;
                    }
                    curToRoot.add(t);
                    t = argument;
                    while ((parentArc = mtree.getOneParent(t)) != null) {
                        dependentToRoot.add(t);
                        queTopToRootLabels.add(parentArc.label);
                        t = parentArc.index;
                    }
                    dependentToRoot.add(t);
                    int leastCommonAncestor = 1;
                    while (leastCommonAncestor <= curToRoot.size() && leastCommonAncestor <= dependentToRoot.size() && curToRoot.get(curToRoot.size() - leastCommonAncestor) == dependentToRoot.get(dependentToRoot.size() - leastCommonAncestor)) {
                        ++leastCommonAncestor;
                    }
                    int pathPoss = n++;
                    int pathP = n++;
                    int pathLab = n++;
                    int i = 0;
                    while (i <= curToRoot.size() - leastCommonAncestor) {
                        pos = sent.getKthPosIndex((Integer)curToRoot.get(i));
                        p = sent.getKthPos((Integer)curToRoot.get(i)).charAt(0);
                        pathPoss = 31 * pathPoss + pos;
                        pathP = 31 * pathP + p;
                        pathLab = 31 * pathLab + ((String)stkTopToRootLabels.get(i)).hashCode();
                        ++i;
                    }
                    pathPoss = -pathPoss;
                    pathP = -pathP;
                    pathLab = -pathLab;
                    if (leastCommonAncestor > 1) {
                        int pos3 = sent.getKthPosIndex((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1));
                        char p3 = sent.getKthPos((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1)).charAt(0);
                        pathPoss = 31 * pathPoss + pos3;
                        pathPoss = 31 * pathPoss + SentenceForDAGParsing.posIndexer.size();
                        pathP = 31 * pathP + p3;
                        pathP = 31 * pathP + 255;
                    }
                    i = dependentToRoot.size() - leastCommonAncestor;
                    while (i >= 0) {
                        pos = sent.getKthPosIndex((Integer)dependentToRoot.get(i));
                        p = sent.getKthPos((Integer)dependentToRoot.get(i)).charAt(0);
                        pathPoss = 31 * pathPoss + pos;
                        pathP = 31 * pathP + p;
                        pathLab = 31 * pathLab + ((String)queTopToRootLabels.get(i)).hashCode();
                        --i;
                    }
                    ret.add(ArgumentCentricDecoder.this.hashInts(pathPoss));
                    ret.add(ArgumentCentricDecoder.this.hashInts(pathP));
                    ret.add(ArgumentCentricDecoder.this.hashInts(pathLab));
                    ret.add(ArgumentCentricDecoder.this.hashInts(pathPoss, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(pathP, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(pathLab, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathPoss, argumentWord, argumentPos, curWord, curPos, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathPoss, argumentWord, argumentPos, curWord, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathPoss, argumentWord, argumentPos, curPos, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathPoss, argumentWord, curWord, curPos, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathPoss, argumentPos, curWord, curPos, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathPoss, argumentWord, curWord, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathPoss, argumentPos, curPos, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathP, argumentWord, argumentPos, curWord, curPos, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathP, argumentWord, argumentPos, curWord, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathP, argumentWord, argumentPos, curPos, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathP, argumentWord, curWord, curPos, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathP, argumentPos, curWord, curPos, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathP, argumentWord, curWord, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathP, argumentPos, curPos, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathLab, argumentWord, argumentPos, curWord, curPos, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathLab, argumentWord, argumentPos, curWord, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathLab, argumentWord, argumentPos, curPos, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathLab, argumentWord, curWord, curPos, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathLab, argumentPos, curWord, curPos, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathLab, argumentWord, curWord, distCur));
                    ret.add(ArgumentCentricDecoder.this.hashInts(n++, pathLab, argumentPos, curPos, distCur));
                }
            }
            return ret;
        }

        public double scoreParents(int dependent, int prev, int cur, SentenceForDAGParsing sent, float[] param) {
            return ArgumentCentricDecoder.this.score(this.parentFeats(dependent, prev, cur, sent), param);
        }
    }
}

