/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;

public class OffsetReader {
    private String path;
    private BufferedReader reader;
    private int offset;
    private String nextLine;
    private static final String doesNotExist = "doesNotExist";

    public OffsetReader(String path) throws IOException {
        this(path, 0);
    }

    public OffsetReader(String path, int offset) throws IOException {
        this.path = path;
        this.reader = IOUtils.openIn(path);
        this.offset = 0;
        this.nextLine = doesNotExist;
        this.setOffset(offset);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean closeEasy() {
        return IOUtils.closeEasy(this.reader);
    }

    public String readLine() throws IOException {
        if (this.nextLine == doesNotExist) {
            this.nextLine = this.reader.readLine();
        }
        String currLine = this.nextLine;
        this.nextLine = this.reader.readLine();
        this.offset += OffsetReader.numChars(currLine);
        return currLine;
    }

    public String peekNextLine() {
        return this.nextLine;
    }

    public static int numChars(String line) {
        return line == null || line == doesNotExist ? 0 : line.length() + 1;
    }

    public void setOffset(int newOffset) throws IOException {
        if (this.offset == newOffset) {
            return;
        }
        if (newOffset > this.offset) {
            int physicalOffset = this.offset + OffsetReader.numChars(this.nextLine);
            if (newOffset < physicalOffset) {
                throw new RuntimeException(String.format("Attempted to seek to a position that is not the beginning of a line: %d<%d<%d", this.offset, newOffset, physicalOffset));
            }
            this.reader.skip(newOffset - physicalOffset);
        } else if (newOffset < this.offset) {
            this.reader.close();
            this.reader = IOUtils.openIn(this.path);
            this.reader.skip(newOffset);
        }
        this.offset = newOffset;
        this.nextLine = doesNotExist;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getPath() {
        return this.path;
    }
}

