/*
 * Decompiled with CFR 0.152.
 */
package SyntaxUtils;

import LinguaView.syntax.CCGInternalNode;
import LinguaView.syntax.CCGNode;
import LinguaView.syntax.CCGTerminalNode;
import SyntaxUtils.Action;
import SyntaxUtils.CCGBinaryRule;
import SyntaxUtils.CCGGrammar;
import SyntaxUtils.CCGParseResult;
import SyntaxUtils.CCGRule;
import SyntaxUtils.CCGUnaryRule;
import SyntaxUtils.EquivState;
import SyntaxUtils.FeatureExtractor;
import SyntaxUtils.FeatureSet;
import SyntaxUtils.PerceptronClassifier;
import SyntaxUtils.SentenceForCCGParsing;
import fig.basic.Pair;
import fig.basic.PriorityQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import jigsaw.syntax.Lexicon;
import jigsaw.util.Triple;

public class CCGChart {
    private static final int DEFAULT_BEAM_SIZE = 16;
    private static final int MAX_RE_SEARCH = 2;
    private static final int MAX_NUM_OF_SUPERTAG = 4;
    public static boolean APPROX_PRUNE = true;
    private SentenceForCCGParsing _sent;
    private Lexicon _wordLexicon;
    private Lexicon _posLexicon;
    private CCGGrammar _grammar;
    private PerceptronClassifier _classifier;
    private String[] _interpretation;
    private List<State> _currStates;
    private List<Action> _goldActions;
    private PriorityQueue<State> _retainedStates;
    private List<State> _historyStates;
    private boolean _finish = false;
    private int _reSearchCount = 0;
    private FeatureExtractor<State> _featureExtractor = new CCGFeatures();
    public int _beam = 16;

    public CCGChart(SentenceForCCGParsing s, CCGNode goldTree, Lexicon wordLex, Lexicon posLex, String[] interpretation, CCGGrammar g, PerceptronClassifier c, int beamSize) {
        this._sent = s;
        this._wordLexicon = wordLex;
        this._posLexicon = posLex;
        this._interpretation = interpretation;
        this._grammar = g;
        this._classifier = c;
        this._currStates = new ArrayList<State>();
        if (APPROX_PRUNE) {
            this._retainedStates = new PriorityQueue();
            this._historyStates = new ArrayList<State>();
        }
        this._beam = beamSize;
        if (goldTree != null) {
            this._goldActions = CCGChart.getActionSequence(goldTree);
        }
    }

    private void proceedOneStep() {
        PriorityQueue<Triple<State, Action, Object>> pq = new PriorityQueue<Triple<State, Action, Object>>();
        for (State state : this._currStates) {
            ArrayList<Action> actions = new ArrayList<Action>();
            for (Action action : this.getShiftActions(state)) {
                actions.add(action);
            }
            for (Action action : this.getReduceActions(state)) {
                actions.add(action);
            }
            for (Action action : actions) {
                State preview = state.preview(action);
                if (preview == null) continue;
                double score = this.evaluateState(preview);
                pq.add(new Triple<State, Action, Object>(state, action, null), score + state.score());
                for (Action actionU : this.getUnaryActions(preview)) {
                    preview = state.preview(action, actionU);
                    if (preview == null) continue;
                    double scoreU = this.evaluateState(preview);
                    pq.add(new Triple<State, Action, Action>(state, action, actionU), score + scoreU + state.score());
                }
            }
        }
        if (pq.size() == 0) {
            if (APPROX_PRUNE && ++this._reSearchCount <= 2) {
                if (!this._retainedStates.isEmpty()) {
                    this._currStates = new ArrayList<State>();
                    while (this._retainedStates.hasNext() && this._currStates.size() < this._beam) {
                        State retainedState = this._retainedStates.next();
                        if (this.pruneThisState(this._currStates, retainedState)) continue;
                        this._currStates.add(retainedState);
                        this._historyStates.add(retainedState);
                    }
                } else {
                    this._finish = true;
                }
            } else {
                this._finish = true;
            }
        } else {
            this._currStates = null;
            this._currStates = new ArrayList<State>();
            int beamSize = this._beam > 0 ? this._beam : 16;
            int numOfShift = 0;
            while (pq.hasNext()) {
                double score = pq.getPriority();
                Triple pair = (Triple)pq.next();
                if (((Action)pair.second()).isShiftAction() && ++numOfShift >= 4) continue;
                State predictorState = (State)pair.first();
                State newState = predictorState.generateNewState((Action)pair.second(), (Action)pair.third());
                newState.score(score);
                if (!APPROX_PRUNE) {
                    this._currStates.add(newState);
                    if (this._currStates.size() < beamSize) continue;
                    break;
                }
                if (this._currStates.size() >= beamSize || this.pruneThisState(this._currStates, newState)) {
                    if (this.pruneThisState(this._historyStates, newState)) continue;
                    this._retainedStates.add(newState, score);
                    continue;
                }
                this._currStates.add(newState);
                this._historyStates.add(newState);
            }
        }
        if (this.isFinished()) {
            return;
        }
    }

    private FeatureSet collectFeats(State init, List<Action> actionSequence) {
        FeatureSet fs = new FeatureSet();
        for (Action act : actionSequence) {
            init.act(act);
            fs.accumulate(this._featureExtractor.getFeatures(init));
        }
        return fs;
    }

    private FeatureSet collectFeats(List<Action> actionSequence) {
        return this.collectFeats(new State(), actionSequence);
    }

    private static List<Action> getActionSequence(Collection<CCGNode> cs) {
        if (cs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Action> sequence = new ArrayList<Action>();
        for (CCGNode cn : cs) {
            sequence.addAll(CCGChart.getActionSequence(cn));
        }
        return sequence;
    }

    private static List<Action> getActionSequence(CCGNode c) {
        Stack<CCGNode> nodesStack = new Stack<CCGNode>();
        Stack<Action> actStack = new Stack<Action>();
        nodesStack.push(c);
        while (nodesStack.size() > 0) {
            CCGNode next = (CCGNode)nodesStack.pop();
            if (next.isTerminal()) {
                String marked = ((CCGTerminalNode)next).category().toMarkedupString();
                if (marked == null) {
                    return null;
                }
                actStack.push(Action.getShiftAction(marked));
                continue;
            }
            CCGInternalNode temp = (CCGInternalNode)next;
            if (temp.prole() == 1) {
                nodesStack.push(temp.daughters()[0]);
                actStack.push(Action.getUnaryAction(new CCGUnaryRule(temp.daughters()[0].categoryToString(), next.categoryToString())));
                continue;
            }
            nodesStack.push(temp.daughters()[0]);
            nodesStack.push(temp.daughters()[1]);
            actStack.push(Action.getReduceAction(new CCGBinaryRule(temp.daughters()[0].categoryToString(), temp.daughters()[1].categoryToString(), next.categoryToString(), temp.headChild)));
        }
        ArrayList<Action> sequence = new ArrayList<Action>();
        while (actStack.size() > 0) {
            sequence.add((Action)actStack.pop());
        }
        return sequence;
    }

    private boolean pruneThisState(List<State> states, State newState) {
        for (State inState : states) {
            if (!inState.isEquivalent(newState)) continue;
            return true;
        }
        return false;
    }

    private boolean isToEarlyUpdate() {
        for (State s : this._currStates) {
            if (!s._gold) continue;
            return false;
        }
        return true;
    }

    private boolean isFinished() {
        if (this._finish) {
            return true;
        }
        if (this._currStates.size() == 0) {
            this._finish = true;
            return true;
        }
        State best = this._currStates.get(0);
        if (best._queueIndex == this._sent.length() && best._stack.size() == 1) {
            this._finish = true;
            return true;
        }
        return false;
    }

    private List<Action> getShiftActions(State s) {
        if (s._queueIndex >= this._sent.length()) {
            return Collections.emptyList();
        }
        Set<Integer> candidates = this._wordLexicon.lookup(this._sent.word(s._queueIndex).toLowerCase());
        if (candidates == null || candidates.size() == 0) {
            candidates = this._posLexicon.lookup(this._sent.pos(s._queueIndex));
        }
        if (candidates == null || candidates.size() == 0) {
            System.err.println("unknown words and pos");
            return Collections.emptyList();
        }
        ArrayList<Action> res = new ArrayList<Action>();
        for (int c : candidates) {
            String interpret = this._interpretation[c];
            res.add(Action.getShiftAction(interpret));
        }
        return res;
    }

    private List<Action> getReduceActions(State s) {
        String rLabel;
        int length = s._stack.size();
        if (length < 2) {
            return Collections.emptyList();
        }
        CCGNode left = (CCGNode)s._stack.get(length - 2);
        CCGNode right = (CCGNode)s._stack.get(length - 1);
        String lLabel = left.categoryToString();
        Set<CCGBinaryRule> candidate = this._grammar.lookup(lLabel, rLabel = right.categoryToString());
        if (candidate == null) {
            CCGBinaryRule tryRule = CCGBinaryRule.tryAllRules(left.category(), right.category());
            if (tryRule == null) {
                return Collections.emptyList();
            }
            candidate = new HashSet<CCGBinaryRule>();
            candidate.add(tryRule);
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        for (CCGBinaryRule r : candidate) {
            actions.add(Action.getReduceAction(r));
        }
        return actions;
    }

    private List<Action> getUnaryActions(State s) {
        int length = s._stack.size();
        if (length == 0) {
            return Collections.emptyList();
        }
        CCGNode top = (CCGNode)s._stack.get(length - 1);
        String label = top.categoryToString().toString();
        Set<CCGUnaryRule> candidate = this._grammar.lookup(label);
        if (candidate == null) {
            return Collections.emptyList();
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        for (CCGUnaryRule cat : candidate) {
            actions.add(Action.getUnaryAction(cat));
        }
        return actions;
    }

    private double evaluateState(State s) {
        FeatureSet feats = this._featureExtractor.getFeatures(s);
        return this._classifier.score(feats);
    }

    public void parse(boolean earlyUpdate) {
        State init = new State();
        this._currStates.add(init);
        while (!this._finish) {
            this.proceedOneStep();
            if (!earlyUpdate || !this.isToEarlyUpdate()) continue;
            this._finish = true;
        }
    }

    public CCGParseResult getResult() {
        return this._currStates.get(0).collectResult();
    }

    public void updateClassifier() {
        if (this._goldActions == null) {
            System.err.println(String.valueOf(this._sent.source) + " is ignored because no gold parse found");
            return;
        }
        State best = this._currStates.get(0);
        if (best._gold) {
            return;
        }
        List<Action> decActs = CCGChart.getActionSequence(best._stack);
        List<Action> goldActs = this._goldActions;
        int firstE = 0;
        State init = new State();
        int end = goldActs.size() < decActs.size() ? goldActs.size() : decActs.size();
        while (firstE < end) {
            if (!decActs.get(firstE).equals(goldActs.get(firstE))) break;
            init.act(goldActs.get(firstE));
            ++firstE;
        }
        State init2 = init.clone();
        FeatureSet feats = this.collectFeats(init, decActs.subList(firstE, decActs.size()));
        this._classifier.minus(feats);
        feats = null;
        feats = this.collectFeats(init2, goldActs.subList(firstE, end));
        this._classifier.plus(feats);
    }

    public static CCGParseResult goldParse(CCGNode cn) {
        SentenceForCCGParsing s = new SentenceForCCGParsing(cn);
        CCGChart chart = new CCGChart(s, null, null, null, null, null, null, 1);
        List<Action> acts = CCGChart.getActionSequence(cn);
        if (acts == null) {
            return null;
        }
        State oneState = chart.new State();
        for (Action act : acts) {
            if (oneState.act(act)) continue;
            return null;
        }
        CCGParseResult pr = oneState.collectResult();
        pr.nodes.get((int)0).source = cn.source;
        return pr;
    }

    public static enum CCGFeatureType {
        L1W_S1C,
        L2W_S1C,
        L3W_S1C,
        N1W_S1C,
        N2W_S1C,
        L1W_N1W_S1C,
        N1W_N2W_S1C,
        L3W_L2W_S1C,
        L2W_L1W_S1C,
        L1P_S1C,
        L2P_S1C,
        L3P_S1C,
        N1P_S1C,
        N2P_S1C,
        L2P_L1P_S1C,
        L3P_L2P_S1C,
        L1P_N1P_S1C,
        N1P_N2P_S1C,
        S1W_S1C,
        S1LeW_S1C,
        S1RiW_S1C,
        S1P_S1C,
        S1LeP_S1C,
        S1RiP_S1C,
        S1LeP_S1RiP_S1C,
        S1W_S2W,
        S1C_S2C,
        S1C_S2C_S3C,
        S1C_S2H,
        S1H_S2C,
        S1C_S2P,
        S1C_S2P_S3P,
        DEP_W2W,
        DEP_P2P,
        DEP_W2P,
        DEP_P2W,
        DEP_W2W_S1C,
        DEP_P2P_S1C,
        DEP_W2P_S1C,
        DEP_P2W_S1C,
        PRED_ARG,
        PRED_ANS,
        ANS_ARG,
        PRED_ARG_NM,
        PRED_ANS_NM,
        ANS_ARG_NM,
        PRED_ARG_NF,
        PRED_ANS_NF,
        ANS_ARG_NF,
        PRED_ARG_NMF,
        PRED_ANS_NMF,
        ANS_ARG_NMF,
        L1A_S1C,
        L2A_S1C,
        L3A_S1C,
        N1A_S1C,
        N2A_S1C,
        L2A_L1A_S1C,
        L3A_L2A_S1C,
        L1A_N1A_S1C,
        N1A_N2A_S1C,
        S1A_S1C,
        S1LeA_S1C,
        S1RiA_S1C,
        S1C_S2A,
        S1C_S2A_S3A;


        String combineTwo(Object f, Object s) {
            return (Object)((Object)this) + "=" + f + "_" + s;
        }

        String combineThree(Object f, Object s, Object t) {
            return (Object)((Object)this) + "=" + f + "_" + s + "_" + t;
        }

        String combineFour(Object f, Object s, Object t, Object fo) {
            return (Object)((Object)this) + "=" + f + "_" + s + "_" + t + "_" + fo;
        }
    }

    private class CCGFeatures
    implements FeatureExtractor<State> {
        private final String SEP = "-";

        private CCGFeatures() {
        }

        @Override
        public int windows() {
            return 3;
        }

        @Override
        public FeatureSet getFeatures(State s) {
            FeatureSet feats = new FeatureSet();
            State preview = s.clone();
            CCGNode[] top = new CCGNode[]{(CCGNode)preview._stack.pop(), preview._stack.empty() ? null : (CCGNode)preview._stack.pop(), preview._stack.empty() ? null : (CCGNode)preview._stack.pop()};
            String top1Cat = top[0].categoryToString();
            String top2Cat = top[1] == null ? "#BOS#" : top[1].categoryToString();
            String top3Cat = top[2] == null ? "#BOS#" : top[2].categoryToString();
            int index = preview._queueIndex;
            String[] nextWord = new String[3];
            String[] lastWord = new String[3];
            String[] nextPos = new String[3];
            String[] lastPos = new String[3];
            int i = 0;
            while (i < 3) {
                nextWord[i] = CCGChart.this._sent.word(index + i);
                ++i;
            }
            i = 0;
            while (i < 3) {
                lastWord[i] = CCGChart.this._sent.word(index - 1 - i);
                ++i;
            }
            i = 0;
            while (i < 3) {
                nextPos[i] = CCGChart.this._sent.pos(index + i);
                ++i;
            }
            i = 0;
            while (i < 3) {
                lastPos[i] = CCGChart.this._sent.pos(index - 1 - i);
                ++i;
            }
            String s1lw = top[0].getLeftmostTerm().word();
            String s1rw = top[0].getRightmostTerm().word();
            String s1lp = top[0].getLeftmostTerm().modPOS();
            String s1rp = top[0].getRightmostTerm().modPOS();
            int s1len = top[0].end() - top[0].start() + 1;
            CCGTerminalNode headTerm1 = top[0].headTerm();
            CCGTerminalNode headTerm2 = top[1] == null ? null : top[1].headTerm();
            CCGTerminalNode headTerm3 = top[2] == null ? null : top[2].headTerm();
            String headWord1 = headTerm1.word();
            String headWord2 = headTerm2 == null ? "#BOS#" : headTerm2.word();
            String headPos1 = headTerm1.modPOS();
            String headPos2 = headTerm2 == null ? "#BOS#" : headTerm2.modPOS();
            String headPos3 = headTerm3 == null ? "#BOS#" : headTerm3.modPOS();
            feats.put(CCGFeatureType.N1W_S1C.combineTwo(nextWord[0], top1Cat));
            feats.put(CCGFeatureType.N2W_S1C.combineTwo(nextWord[1], top1Cat));
            feats.put(CCGFeatureType.L1W_S1C.combineTwo(lastWord[0], top1Cat));
            feats.put(CCGFeatureType.L2W_S1C.combineTwo(lastWord[1], top1Cat));
            feats.put(CCGFeatureType.L3W_S1C.combineTwo(lastWord[2], top1Cat));
            feats.put(CCGFeatureType.L1W_N1W_S1C.combineThree(lastWord[0], nextWord[0], top1Cat));
            feats.put(CCGFeatureType.N1W_N2W_S1C.combineThree(nextWord[0], nextWord[1], top1Cat));
            feats.put(CCGFeatureType.L3W_L2W_S1C.combineThree(lastWord[2], lastWord[1], top1Cat));
            feats.put(CCGFeatureType.L2W_L1W_S1C.combineThree(lastWord[1], lastWord[0], top1Cat));
            feats.put(CCGFeatureType.N1P_S1C.combineTwo(nextPos[0], top1Cat));
            feats.put(CCGFeatureType.N2P_S1C.combineTwo(nextPos[1], top1Cat));
            feats.put(CCGFeatureType.L1P_S1C.combineTwo(lastPos[0], top1Cat));
            feats.put(CCGFeatureType.L2P_S1C.combineTwo(lastPos[1], top1Cat));
            feats.put(CCGFeatureType.L3P_S1C.combineTwo(lastPos[2], top1Cat));
            feats.put(CCGFeatureType.L1P_N1P_S1C.combineThree(lastPos[0], nextPos[0], top1Cat));
            feats.put(CCGFeatureType.N1P_N2P_S1C.combineThree(nextPos[0], nextPos[1], top1Cat));
            feats.put(CCGFeatureType.L3P_L2P_S1C.combineThree(lastPos[2], lastPos[1], top1Cat));
            feats.put(CCGFeatureType.L2P_L1P_S1C.combineThree(lastPos[1], lastPos[0], top1Cat));
            feats.put(CCGFeatureType.S1W_S1C.combineTwo(headWord1, top1Cat));
            feats.put(CCGFeatureType.S1P_S1C.combineTwo(headPos1, top1Cat));
            if (s1len > 1) {
                feats.put(CCGFeatureType.S1LeW_S1C.combineTwo(s1lw, top1Cat));
                feats.put(CCGFeatureType.S1RiW_S1C.combineTwo(s1rw, top1Cat));
                feats.put(CCGFeatureType.S1LeP_S1C.combineTwo(s1lp, top1Cat));
                feats.put(CCGFeatureType.S1RiP_S1C.combineTwo(s1rp, top1Cat));
                feats.put(CCGFeatureType.S1LeP_S1RiP_S1C.combineThree(s1lp, s1rp, top1Cat));
            }
            feats.put(CCGFeatureType.S1W_S2W.combineTwo(headWord1, headWord2));
            feats.put(CCGFeatureType.S1C_S2C.combineTwo(top1Cat, top2Cat));
            feats.put(CCGFeatureType.S1C_S2C_S3C.combineThree(top1Cat, top2Cat, top3Cat));
            feats.put(CCGFeatureType.S1C_S2H.combineTwo(top1Cat, headWord2));
            feats.put(CCGFeatureType.S1H_S2C.combineTwo(headWord1, top2Cat));
            feats.put(CCGFeatureType.S1C_S2P.combineTwo(top1Cat, headPos2));
            feats.put(CCGFeatureType.S1C_S2P_S3P.combineThree(top1Cat, headPos2, headPos3));
            if (headTerm1.additionalInfo != null) {
                String[] nextAdds = new String[3];
                String[] lastAdds = new String[3];
                String headAdd1 = headTerm1.additionalInfo;
                String headAdd2 = headTerm2 == null ? "#BOS#" : headTerm2.additionalInfo;
                String headAdd3 = headTerm3 == null ? "#BOS#" : headTerm3.additionalInfo;
                String s1la = top[0].getLeftmostTerm().additionalInfo;
                String s1ra = top[0].getRightmostTerm().additionalInfo;
                int i2 = 0;
                while (i2 < 3) {
                    nextAdds[i2] = CCGChart.this._sent.additionalInfo(index + i2);
                    ++i2;
                }
                i2 = 0;
                while (i2 < 3) {
                    lastAdds[i2] = CCGChart.this._sent.additionalInfo(index - 1 - i2);
                    ++i2;
                }
                feats.put(String.valueOf(CCGFeatureType.S1A_S1C.ordinal()) + "-" + headAdd1 + "-" + top1Cat);
                feats.put(String.valueOf(CCGFeatureType.S1LeA_S1C.ordinal()) + "-" + s1la + "-" + top1Cat);
                feats.put(String.valueOf(CCGFeatureType.S1RiA_S1C.ordinal()) + "-" + s1ra + "-" + top1Cat);
                feats.put(String.valueOf(CCGFeatureType.S1C_S2A.ordinal()) + "-" + top1Cat + "-" + headAdd2);
                feats.put(String.valueOf(CCGFeatureType.S1C_S2A_S3A.ordinal()) + "-" + top1Cat + "-" + headAdd2 + "-" + headAdd3);
                feats.put(String.valueOf(CCGFeatureType.N1A_S1C.ordinal()) + "-" + nextAdds[0] + "-" + top1Cat);
                feats.put(String.valueOf(CCGFeatureType.N2A_S1C.ordinal()) + "-" + nextAdds[1] + "-" + top1Cat);
                feats.put(String.valueOf(CCGFeatureType.L1A_S1C.ordinal()) + "-" + lastAdds[0] + "-" + top1Cat);
                feats.put(String.valueOf(CCGFeatureType.L2A_S1C.ordinal()) + "-" + lastAdds[1] + "-" + top1Cat);
                feats.put(String.valueOf(CCGFeatureType.L3A_S1C.ordinal()) + "-" + lastAdds[2] + "-" + top1Cat);
                feats.put(String.valueOf(CCGFeatureType.L1A_N1A_S1C.ordinal()) + "-" + lastAdds[0] + "-" + nextAdds[0] + "-" + top1Cat);
                feats.put(String.valueOf(CCGFeatureType.N1A_N2A_S1C.ordinal()) + "-" + nextAdds[0] + "-" + nextAdds[1] + "-" + top1Cat);
                feats.put(String.valueOf(CCGFeatureType.L3A_L2A_S1C.ordinal()) + "-" + lastAdds[2] + "-" + lastAdds[1] + "-" + top1Cat);
                feats.put(String.valueOf(CCGFeatureType.L2A_L1A_S1C.ordinal()) + "-" + lastAdds[1] + "-" + lastAdds[0] + "-" + top1Cat);
            }
            if (top[0] instanceof CCGInternalNode) {
                CCGInternalNode tn = (CCGInternalNode)top[0];
                Set<Integer> newlyInactiveNodes = top[0].collectNewInactiveNodes();
                for (int ii : newlyInactiveNodes) {
                    CCGTerminalNode predNode = tn.getTerminalNode(ii);
                    int jj = 0;
                    while (jj < top[0].slots[ii - top[0].start()].length) {
                        for (int kk : top[0].slots[ii - top[0].start()][jj]) {
                            StringBuffer w2w = new StringBuffer(predNode.word());
                            StringBuffer p2p = new StringBuffer(predNode.modPOS());
                            StringBuffer w2p = new StringBuffer(predNode.word());
                            StringBuffer p2w = new StringBuffer(predNode.modPOS());
                            CCGTerminalNode argNode = top[0].getTerminalNode(kk);
                            w2w.append("-" + argNode.word());
                            w2p.append("-" + argNode.modPOS());
                            feats.put(String.valueOf(CCGFeatureType.DEP_W2W.ordinal()) + "-" + w2w.toString());
                            feats.put(String.valueOf(CCGFeatureType.DEP_W2P.ordinal()) + "-" + w2p.toString());
                            feats.put(String.valueOf(CCGFeatureType.DEP_W2W_S1C.ordinal()) + "-" + w2w.toString() + "-" + top1Cat);
                            feats.put(String.valueOf(CCGFeatureType.DEP_W2P_S1C.ordinal()) + "-" + w2p.toString() + "-" + top1Cat);
                            p2p.append("-" + argNode.modPOS());
                            p2w.append("-" + argNode.word());
                            feats.put(String.valueOf(CCGFeatureType.DEP_P2P.ordinal()) + "-" + p2p.toString());
                            feats.put(String.valueOf(CCGFeatureType.DEP_P2W.ordinal()) + "-" + p2w.toString());
                            feats.put(String.valueOf(CCGFeatureType.DEP_P2P_S1C.ordinal()) + "-" + p2p.toString() + "-" + top1Cat);
                            feats.put(String.valueOf(CCGFeatureType.DEP_P2W_S1C.ordinal()) + "-" + p2w.toString() + "-" + top1Cat);
                        }
                        ++jj;
                    }
                }
            }
            return feats;
        }
    }

    private class State
    implements EquivState<State> {
        private Stack<CCGNode> _stack;
        private int _queueIndex;
        public boolean _gold;
        private double _score;
        Map<Action, CCGNode> _cache = new HashMap<Action, CCGNode>();
        Map<Pair<Action, Action>, CCGNode> _cacheU = new HashMap<Pair<Action, Action>, CCGNode>();
        int _step;
        CCGRule _lastRule = null;

        public State() {
            this._stack = new Stack();
            this._queueIndex = 0;
            this._gold = true;
            this._step = 0;
        }

        private boolean isFinished() {
            return this._queueIndex == CCGChart.this._sent.length() && this._stack.size() == 1;
        }

        public State clone() {
            Stack<CCGNode> newStack = new Stack<CCGNode>();
            newStack.addAll(this._stack);
            State s = new State(newStack, this._queueIndex, this._gold, this._step, this._score);
            s.setLastRule(this._lastRule);
            return s;
        }

        private State(Stack<CCGNode> stk, int queueIndex, boolean gold, int step, double score) {
            this._stack = stk;
            this._queueIndex = queueIndex;
            this._gold = gold;
            this._step = step;
            this._score = score;
        }

        private CCGNode nextNodeToStack(Action action) {
            int size = this._stack.size();
            if (action.isShiftAction()) {
                return new CCGTerminalNode(CCGChart.this._sent.word(this._queueIndex), CCGChart.this._sent.pos(this._queueIndex), action._tag, CCGChart.this._sent.additionalInfo(this._queueIndex), this._queueIndex);
            }
            if (action.isBinaryReduceAction()) {
                CCGNode rChild = (CCGNode)this._stack.get(size - 1);
                CCGNode lChild = (CCGNode)this._stack.get(size - 2);
                CCGInternalNode parent = CCGInternalNode.generateNewNode(action._bRule, lChild, rChild);
                return parent;
            }
            if (action.isUnaryReduceAction()) {
                CCGNode child = (CCGNode)this._stack.get(size - 1);
                CCGInternalNode newNode = CCGInternalNode.generateNewNode(action._uRule, child);
                return newNode;
            }
            return null;
        }

        private State setLastRule(CCGRule rule) {
            this._lastRule = rule;
            return this;
        }

        private State preview(Action action) {
            int windows = CCGChart.this._featureExtractor.windows();
            State pre = new State();
            pre._step = this._step;
            pre._queueIndex = this._queueIndex;
            pre._gold = this._gold;
            int size = this._stack.size();
            if (action.isShiftAction()) {
                --windows;
            } else if (action.isBinaryReduceAction()) {
                ++windows;
            }
            int newSize = size < windows ? size : windows;
            int i = size - newSize;
            while (i < size) {
                pre._stack.push((CCGNode)this._stack.get(i));
                ++i;
            }
            CCGNode cn = this._cache.get(action);
            if (cn == null) {
                cn = this.nextNodeToStack(action);
                if (cn == null) {
                    return null;
                }
                this._cache.put(action, cn);
            }
            if (action.isShiftAction() || action.isBinaryReduceAction() || action.isUnaryReduceAction()) {
                return pre.generateNewState(action);
            }
            return pre;
        }

        private State preview(Action actionB, Action actionU) {
            if (actionU == null) {
                return this.preview(actionB);
            }
            if (actionB.isUnaryReduceAction() || !actionU.isUnaryReduceAction()) {
                throw new IllegalArgumentException("wrong argument in preview");
            }
            State pre = this.preview(actionB);
            if (pre == null) {
                return null;
            }
            CCGNode cn = this._cacheU.get(new Pair<Action, Action>(actionB, actionU));
            if (cn == null) {
                cn = pre.nextNodeToStack(actionU);
            }
            if (cn == null) {
                return null;
            }
            pre._stack.pop();
            pre._stack.push(cn);
            pre.setLastRule(actionU._uRule);
            this._cacheU.put(new Pair<Action, Action>(actionB, actionU), cn);
            return pre;
        }

        public State generateNewState(Action action) {
            State newState = this.clone();
            newState.act(action);
            return newState;
        }

        public State generateNewState(Action actionB, Action actionU) {
            State newState = this.clone();
            newState.act(actionB, actionU);
            return newState;
        }

        private boolean act(Action actionB, Action actionU) {
            if (actionU == null) {
                CCGNode top = this._cache.get(actionB);
                if (top == null) {
                    top = this.nextNodeToStack(actionB);
                }
                if (top == null) {
                    return false;
                }
                return this.act(actionB, top);
            }
            if (!actionU.isUnaryReduceAction()) {
                throw new IllegalArgumentException("second argument of act");
            }
            CCGNode topB = this._cache.get(actionB);
            if (topB == null && (topB = this.nextNodeToStack(actionB)) == null) {
                return false;
            }
            if (!this.act(actionB, topB)) {
                return false;
            }
            CCGNode top = this._cacheU.get(new Pair<Action, Action>(actionB, actionU));
            if (top == null && (top = CCGInternalNode.generateNewNode(actionU._uRule, topB)) == null) {
                return false;
            }
            return this.act(actionU, top);
        }

        private boolean act(Action action) {
            CCGNode top = null;
            if (this._cache != null) {
                top = this._cache.get(action);
            }
            if (top == null) {
                top = this.nextNodeToStack(action);
            }
            if (top == null) {
                return false;
            }
            if (this._gold && !this.isGoldAction(action)) {
                this._gold = false;
            }
            return this.act(action, top);
        }

        private boolean isGoldAction(Action action) {
            if (CCGChart.this._goldActions == null) {
                return false;
            }
            if (this._step >= CCGChart.this._goldActions.size()) {
                return false;
            }
            return action.equals(CCGChart.this._goldActions.get(this._step));
        }

        private boolean act(Action action, CCGNode top) {
            if (top == null) {
                return false;
            }
            if (action.isShiftAction()) {
                this._stack.push(top);
                ++this._queueIndex;
                this._lastRule = null;
            } else if (action.isBinaryReduceAction()) {
                this._stack.pop();
                this._stack.pop();
                this._stack.push(top);
                this._lastRule = action._bRule;
            } else if (action.isUnaryReduceAction()) {
                this._stack.pop();
                this._stack.push(top);
                this._lastRule = action._uRule;
            }
            if (this._cache != null) {
                this._cache.clear();
            }
            if (this._cacheU != null) {
                this._cacheU.clear();
            }
            if (this._gold && !this.isGoldAction(action)) {
                this._gold = false;
            }
            ++this._step;
            return true;
        }

        public CCGParseResult collectResult() {
            CCGParseResult res = new CCGParseResult();
            res.nodes = new ArrayList<CCGNode>(this._stack);
            res.dependency = new Set[CCGChart.this._sent.length()][];
            for (CCGNode cn : this._stack) {
                int i = cn.start();
                while (i <= cn.end()) {
                    res.dependency[i] = new Set[cn.slots[i - cn.start()].length];
                    int j = 0;
                    while (j < res.dependency[i].length) {
                        res.dependency[i][j] = cn.slots[i - cn.start()][j] == null ? null : new HashSet<Integer>(cn.slots[i - cn.start()][j]);
                        ++j;
                    }
                    ++i;
                }
            }
            res.isDone = this.isFinished();
            res.source = ((CCGChart)CCGChart.this)._sent.source;
            return res;
        }

        private void score(double s) {
            this._score = s;
        }

        private double score() {
            return this._score;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this._gold ? "G-" : "NG-");
            sb.append(String.valueOf(this._queueIndex) + ": ");
            for (CCGNode cn : this._stack) {
                sb.append(cn + "\n");
            }
            return sb.toString();
        }

        @Override
        public boolean isEquivalent(State another) {
            CCGNode last2CcgNodeOfFirst;
            CCGNode lastCcgNodeOfFirst;
            if (this._stack.size() >= 3 && another._stack.size() >= 3) {
                lastCcgNodeOfFirst = this._stack.peek();
                last2CcgNodeOfFirst = (CCGNode)this._stack.elementAt(this._stack.size() - 2);
                CCGNode last3CcgNodeOfFirst = (CCGNode)this._stack.elementAt(this._stack.size() - 3);
                CCGNode lastCcgNodeOfSecond = another._stack.peek();
                CCGNode last2CcgNodeOfSecond = (CCGNode)another._stack.elementAt(another._stack.size() - 2);
                CCGNode last3CcgNodeOfSecond = (CCGNode)another._stack.elementAt(another._stack.size() - 3);
                if (lastCcgNodeOfFirst.end() == lastCcgNodeOfSecond.end() && last2CcgNodeOfFirst.categoryToString().equals(last2CcgNodeOfSecond.categoryToString()) && last3CcgNodeOfFirst.categoryToString().equals(last3CcgNodeOfSecond.categoryToString()) && lastCcgNodeOfFirst.categoryToString().equals(lastCcgNodeOfSecond.categoryToString())) {
                    return true;
                }
            }
            if (this._stack.size() >= 2 && another._stack.size() >= 2) {
                lastCcgNodeOfFirst = this._stack.peek();
                last2CcgNodeOfFirst = (CCGNode)this._stack.elementAt(this._stack.size() - 2);
                CCGNode lastCcgNodeOfSecond = another._stack.peek();
                CCGNode last2CcgNodeOfSecond = (CCGNode)another._stack.elementAt(another._stack.size() - 2);
                if (lastCcgNodeOfFirst.end() == lastCcgNodeOfSecond.end() && last2CcgNodeOfFirst.categoryToString().equals(last2CcgNodeOfSecond.categoryToString()) && lastCcgNodeOfFirst.categoryToString().equals(lastCcgNodeOfSecond.categoryToString())) {
                    return true;
                }
            } else if (this._stack.size() == 1 && another._stack.size() == 1) {
                lastCcgNodeOfFirst = this._stack.peek();
                CCGNode lastCcgNodeOfSecond = another._stack.peek();
                if (lastCcgNodeOfFirst.end() == lastCcgNodeOfSecond.end() && lastCcgNodeOfFirst.categoryToString().equals(lastCcgNodeOfSecond.categoryToString())) {
                    return true;
                }
            }
            return false;
        }
    }
}

