/*
 * Decompiled with CFR 0.152.
 */
package LinguaView.syntax;

public class Edge {
    private int startid;
    private int endid;
    private String label;

    public Edge() {
    }

    public Edge(int startid, int endid) {
        this(startid, endid, "-");
    }

    public Edge(int startid, int endid, String label) {
        this.startid = startid;
        this.endid = endid;
        this.label = label;
    }

    public int getStart() {
        return this.startid;
    }

    public int getEnd() {
        return this.endid;
    }

    public String getLabel() {
        return this.label;
    }

    public int getSpanLength() {
        return this.getLargeIndex() - this.getSmallIndex();
    }

    public boolean isSelfLoop() {
        return this.endid == this.startid;
    }

    public int getLargeIndex() {
        return this.startid > this.endid ? this.startid : this.endid;
    }

    public int getSmallIndex() {
        return this.startid < this.endid ? this.startid : this.endid;
    }

    public boolean getDirection() {
        return this.endid > this.startid;
    }

    public static boolean isCross(Edge e1, Edge e2) {
        if (e1.isSelfLoop() || e2.isSelfLoop()) {
            return false;
        }
        if (e1.getLargeIndex() > e2.getSmallIndex() && e2.getSmallIndex() > e1.getSmallIndex() && e2.getLargeIndex() > e1.getLargeIndex()) {
            return true;
        }
        return e1.getLargeIndex() > e2.getLargeIndex() && e2.getLargeIndex() > e1.getSmallIndex() && e2.getSmallIndex() < e1.getSmallIndex();
    }

    public static boolean isSeparate(Edge e1, Edge e2) {
        if (e1.getLargeIndex() <= e2.getSmallIndex()) {
            return true;
        }
        return e1.getSmallIndex() >= e2.getLargeIndex();
    }

    public static boolean isNested(Edge e1, Edge e2) {
        return e1.getLargeIndex() >= e2.getLargeIndex() && e1.getSmallIndex() <= e2.getSmallIndex();
    }
}

