def conv(score, multiply=False):
    if type(score) == float:
        if multiply:
            return '{:.4f}'.format(score*100)
        else:
            return '{:.4f}'.format(score)
    elif type(score) == str and score != '---':
        if multiply:
            return '{:.4f}'.format(float(score)*100)
        else:
            return '{:.4f}'.format(float(score))
    else:
        return score
def conv2(score, multiply=False):
    if type(score) == float:
        if multiply:
            return '{:.2f}'.format(score*100)
        else:
            return '{:.2f}'.format(score)
    elif type(score) == str and score != '---':
        if multiply:
            return '{:.2f}'.format(float(score)*100)
        else:
            return '{:.2f}'.format(float(score))
    else:
        return score

def load(name):
    data = {}
    for line in open('results/' + name ):
        tok = line.strip().split('\t')
        treebank = tok[0]
        data[treebank] = tok[1:]
    return data

all2 = load('test.tok.2.2.all')
train2 = load('test.tok.2.2.train')
all5 = load('test.tok.2.5.all')
train5 = load('test.tok.2.5.train')
all10 = load('test.tok.2.10.all')
train10 = load('test.tok.2.10.train')

allTreebanks = set(list(all2) + list(all5) + list(all10))
for treebank in sorted (allTreebanks):
    row = [treebank.replace('_', '\\_')]
    for resultList in [all2, all5, all10]:
        if treebank in resultList:
            row.extend([conv(x, x_idx!=0) for x_idx, x in enumerate(resultList[treebank])])
        else:
            row.extend(['---', '---', '---'])
    print(' & '.join(row) + ' \\\\')


print()
print('2.2-train 2.5-train 2.10-train  2.2-all 2.5-all 2.10-all')

data = []
def getScores(resultList):
    avgs = []
    for i in range(4):
        allScores = [resultList[treebank][i] for  treebank in resultList]
        if '---' in allScores:
            avgs.append('---')
            continue
        total = sum([float(resultList[treebank][i]) for  treebank in resultList])
        avgs.append(total/len(resultList))
    return avgs 
data = []
data.append(getScores(train2))
data.append(getScores(train5))
data.append(getScores(train10))
data.append(getScores(all2))
data.append(getScores(all5))
data.append(getScores(all10))
data = [*zip(*data)]
for rowIdx, row in enumerate(data):
    print(' & '.join([conv2(x, rowIdx>0) for x in row]) + ' \\\\')


    

